import { getToken } from '@/api/xmhActivity/index.js'

const ossUploadFile = (tempFilePaths) => {
	return new Promise((resolve, reject) => {
		getToken().then(res => {
			const result = res.data; //获取token数据
			console.log('获取token数据:',result)
			let _key = `${result.dir}${result.fileName}.jpg`
			console.log(_key,'----处理好的file文件')
			uni.uploadFile({
				url: result.host, // 开发者服务器的URL。
				filePath: tempFilePaths, //上传图片资源
				name: 'file', // 必须填file
				header: {
					"Content-Type": "multipart/form-data",
				},
				formData: {
					key:_key,
					policy: result.policy,
					OSSAccessKeyId: result.ossAccessKeyId,
					signature: result.signature,
					'success_action_status': '200',
					'x-oss-security-token': result.stsToken // 使用STS签名时必传。
				},
				success: (res) => {
					console.log('扫码上传Oss处理结果:', res)
					const ossUrl = `${result.host}/${result.dir}${result.fileName}.jpg`
					if (res.statusCode === 200) {
						resolve(ossUrl)
					}else{
						resolve('')
					}
				},
				fail: err => {
					console.error('上传oss失败')
					reject(err)
				}
			});
		})
	})
}
export default ossUploadFile