# 星妈实验室详情页面 (XingmaLabDetailPage)

## 概述

这是一个基于Vue 3 Composition API开发的星妈实验室详情页面组件，用于展示藏品详情、点赞和分享功能。

## 功能特性

- **藏品展示**：展示藏品图片、编号和标题
- **动态时间**：自动显示当前时间
- **点赞功能**：支持点赞/取消点赞状态切换
- **分享功能**：集成uni-app分享API
- **响应式设计**：支持不同屏幕尺寸的适配
- **交互动画**：包含淡入动画和悬停效果

## 文件结构

```
XingmaLabDetailPage/
├── XingmaLabDetailPage.vue    # 主组件文件
├── XingmaLabDetailPage.less   # 样式文件
├── mock-configs.js                   # 配置文件
└── README.md                   # 说明文档
```

## 使用方法

### 1. 基本使用

```vue
<template>
  <XingmaLabDetailPage />
</template>

<script setup>
import XingmaLabDetailPage from '@/pages/XingmaLabDetailPage/XingmaLabDetailPage.vue'
</script>
```

### 2. 功能说明

#### 藏品信息展示
- 藏品背景图片
- 藏品主图片
- 藏品编号（唯一标识）
- 藏品标题

#### 交互功能
- **点赞按钮**：点击切换点赞状态，显示相应提示
- **分享按钮**：调用uni-app分享功能

#### 时间显示
- 自动显示当前日期和地点
- 格式：YYYY-MM-DD 北京

## 配置说明

### 图片资源配置

在 `mock-configs.js` 中配置图片资源路径：

```javascript
export const xingmaLabDetailConfig = {
  baseUrl: 'https://factory-walk.feihe.com',
  images: {
    background: '/farqbxzczytcami/images/XingmaLabDetailPage/XingmaLabDetailPageBg.png',
    picBg: '/farqbxzczytcami/images/XingmaLabDetailPage/XingmaLabDetailPagePicBg.png',
    pic: '/farqbxzczytcami/images/XingmaLabDetailPage/XingmaLabDetailPagePic.png',
    // ... 其他图片配置
  }
}
```

### 文案配置

```javascript
texts: {
  title: '快来用星妈会小程序',
  collectionNumber: '唯一藏品编号：'
}
```

## 样式定制

### 主要样式类

- `.xingmalabdetailpage`: 主容器
- `.xingmalabdetailpagebg`: 背景图片
- `.xingmalabdetailpagepic`: 藏品主图片
- `.xingmalabdetailpagepicbg`: 图片背景框
- `.xingmalabdetailpagebottomcon`: 底部操作容器
- `.xingmalabdetailpagebottomconlikebtn`: 点赞按钮
- `.xingmalabdetailpagebottomconsharebtn`: 分享按钮

### 响应式断点

- 默认：750rpx 宽度（移动端）
- 响应式：小于750px时自动适配为100vw

### 动画效果

- `fadeIn`: 页面淡入动画
- `slideInUp`: 图片和底部容器从下往上滑入动画
- 点赞状态变化时的视觉反馈

## 交互功能

### 点赞功能

```javascript
const handleLikeClick = () => {
  isLiked.value = !isLiked.value
  // 显示点赞状态提示
  uni.showToast({
    title: isLiked.value ? '已点赞' : '取消点赞',
    icon: 'success'
  })
}
```

### 分享功能

```javascript
const handleShareClick = () => {
  // 调用uni-app分享API
  uni.showShareMenu({
    withShareTicket: true,
    menus: ['shareAppMessage', 'shareTimeline']
  })
}
```

## 开发规范

- 使用Vue 3 Composition API
- 遵循项目ESLint和Prettier规范
- 使用Less预处理器
- 支持uni-app跨平台开发
- 使用响应式数据管理状态

## 注意事项

1. 确保图片资源路径正确配置
2. 图片资源需要支持HTTPS协议
3. 组件使用绝对定位布局，注意父容器样式设置
4. 点赞状态会保存在组件内部，页面刷新后会重置
5. 时间显示基于客户端时间，确保设备时间准确

## 更新日志

- v1.0.0: 初始版本，支持藏品展示、点赞和分享功能
- 支持动态资源管理和响应式设计
- 集成uni-app分享API
- 添加交互动画和状态反馈
