const version = 'goodsDetail_v1'

export const shareBtn = `${version}/goodsDetail/shareBtn.png`
export const rightsBtn = `${version}/goodsDetail/rightsBtn.png`

// 产品完整信息映射常量
export const PRODUCT_MAP = {
  'chunrui_a2': {
    name: '淳芮A2',
    shareImage: `${version}/goodsDetail/shareImg/chunrui_a2.png`,
    shareText: '淳芮A2',
    productImages: [
      `${version}/goodsDetail/productImg/淳芮A2.jpg`
      // `${version}/goodsDetail/productImg/淳芮A2/淳芮A2_02.jpg`,
      // `${version}/goodsDetail/productImg/淳芮A2/淳芮A2_03.jpg`,
      // `${version}/goodsDetail/productImg/淳芮A2/淳芮A2_04.jpg`,
      // `${version}/goodsDetail/productImg/淳芮A2/淳芮A2_05.jpg`
    ]
  },
  'xiaoyang_miaoke': {
    name: '小羊妙可',
    shareImage: `${version}/goodsDetail/shareImg/xiaoyang_miaoke.png`,
    shareText: '小羊妙可',
    productImages: [
      `${version}/goodsDetail/productImg/小羊妙可/小羊妙可_01.jpg`,
      `${version}/goodsDetail/productImg/小羊妙可/小羊妙可_02.jpg`,
      `${version}/goodsDetail/productImg/小羊妙可/小羊妙可_03.jpg`,
      `${version}/goodsDetail/productImg/小羊妙可/小羊妙可_04.jpg`,
      `${version}/goodsDetail/productImg/小羊妙可/小羊妙可_05.jpg`,
      `${version}/goodsDetail/productImg/小羊妙可/小羊妙可_06.jpg`
    ]
  },
  'xingfeifan_xiaoyang': {
    name: '星飞帆小羊',
    shareImage: `${version}/goodsDetail/shareImg/xingfeifan_xiaoyang.png`,
    shareText: '星飞帆小羊',
    productImages: [
      `${version}/goodsDetail/productImg/星飞帆小羊/星飞帆小羊_01.jpg`,
      `${version}/goodsDetail/productImg/星飞帆小羊/星飞帆小羊_02.jpg`,
      `${version}/goodsDetail/productImg/星飞帆小羊/星飞帆小羊_03.jpg`,
      `${version}/goodsDetail/productImg/星飞帆小羊/星飞帆小羊_04.jpg`,
      `${version}/goodsDetail/productImg/星飞帆小羊/星飞帆小羊_05.jpg`,
      `${version}/goodsDetail/productImg/星飞帆小羊/星飞帆小羊_06.jpg`,
      `${version}/goodsDetail/productImg/星飞帆小羊/星飞帆小羊_07.jpg`
    ]
  },
  'xingfeifan_zhuochu_a2_red': {
    name: '星飞帆卓初A2中国红',
    shareImage: `${version}/goodsDetail/shareImg/xingfeifan_zhuochu_a2_red.png`,
    shareText: '星飞帆卓初中国红',
    productImages: [
      `${version}/goodsDetail/productImg/星飞帆卓初A2中国红/星飞帆卓初A2中国红_01.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓初A2中国红/星飞帆卓初A2中国红_02.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓初A2中国红/星飞帆卓初A2中国红_03.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓初A2中国红/星飞帆卓初A2中国红_04.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓初A2中国红/星飞帆卓初A2中国红_05.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓初A2中国红/星飞帆卓初A2中国红_06.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓初A2中国红/星飞帆卓初A2中国红_07.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓初A2中国红/星飞帆卓初A2中国红_08.jpg`
    ]
  },
  'xingfeifan_zhuochu_organic_a2_purple': {
    name: '星飞帆卓初有机A2华夏紫',
    shareImage: `${version}/goodsDetail/shareImg/xingfeifan_zhuochu_organic_a2_purple.png`,
    shareText: '星飞帆卓初华夏紫',
    productImages: [
      `${version}/goodsDetail/productImg/星飞帆卓初有机A2华夏紫/星飞帆卓初有机A2华夏紫_01.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓初有机A2华夏紫/星飞帆卓初有机A2华夏紫_02.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓初有机A2华夏紫/星飞帆卓初有机A2华夏紫_03.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓初有机A2华夏紫/星飞帆卓初有机A2华夏紫_04.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓初有机A2华夏紫/星飞帆卓初有机A2华夏紫_05.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓初有机A2华夏紫/星飞帆卓初有机A2华夏紫_06.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓初有机A2华夏紫/星飞帆卓初有机A2华夏紫_07.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓初有机A2华夏紫/星飞帆卓初有机A2华夏紫_08.jpg`
    ]
  },
  'xingfeifan_zhuorui': {
    name: '星飞帆卓睿',
    shareImage: `${version}/goodsDetail/shareImg/xingfeifan_zhuorui.png`,
    shareText: '星飞帆卓睿',
    productImages: [
      `${version}/goodsDetail/productImg/星飞帆卓睿/星飞帆卓睿_01.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓睿/星飞帆卓睿_02.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓睿/星飞帆卓睿_03.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓睿/星飞帆卓睿_04.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓睿/星飞帆卓睿_05.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓睿/星飞帆卓睿_06.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓睿/星飞帆卓睿_07.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓睿/星飞帆卓睿_08.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓睿/星飞帆卓睿_09.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓睿/星飞帆卓睿_10.jpg`
    ]
  },
  'xingfeifan_zhuorui_pro': {
    name: '星飞帆卓睿Pro',
    shareImage: `${version}/goodsDetail/shareImg/xingfeifan_zhuorui_pro.png`,
    shareText: '星飞帆卓睿Pro',
    productImages: [
      `${version}/goodsDetail/productImg/星飞帆卓睿Pro/星飞帆卓睿Pro_01.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓睿Pro/星飞帆卓睿Pro_02.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓睿Pro/星飞帆卓睿Pro_03.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓睿Pro/星飞帆卓睿Pro_05.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓睿Pro/星飞帆卓睿Pro_06.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓睿Pro/星飞帆卓睿Pro_07.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓睿Pro/星飞帆卓睿Pro_08.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓睿Pro/星飞帆卓睿Pro_09.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓睿Pro/星飞帆卓睿Pro_10.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓睿Pro/星飞帆卓睿Pro_11.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓睿Pro/星飞帆卓睿Pro_12.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓睿Pro/星飞帆卓睿Pro_13.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓睿Pro/星飞帆卓睿Pro_14.jpg`
    ]
  },
  'xingfeifan_zhuoshu': {
    name: '星飞帆卓舒',
    shareImage: `${version}/goodsDetail/shareImg/xingfeifan_zhuoshu.png`,
    shareText: '星飞帆卓舒',
    productImages: [
      `${version}/goodsDetail/productImg/星飞帆卓舒/星飞帆卓舒_01.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓舒/星飞帆卓舒_02.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓舒/星飞帆卓舒_03.jpg`,
      `${version}/goodsDetail/productImg/星飞帆卓舒/星飞帆卓舒_04.jpg`
    ]
  },
  'zhenzhi_zhuobei': {
    name: '臻稚卓蓓',
    shareImage: `${version}/goodsDetail/shareImg/zhenzhi_zhuobei.png`,
    shareText: '臻稚卓蓓',
    productImages: [
      `${version}/goodsDetail/productImg/臻稚卓蓓/臻稚卓蓓_01.jpg`,
      `${version}/goodsDetail/productImg/臻稚卓蓓/臻稚卓蓓_02.jpg`,
      `${version}/goodsDetail/productImg/臻稚卓蓓/臻稚卓蓓_03.jpg`,
      `${version}/goodsDetail/productImg/臻稚卓蓓/臻稚卓蓓_04.jpg`,
      `${version}/goodsDetail/productImg/臻稚卓蓓/臻稚卓蓓_05.jpg`,
      `${version}/goodsDetail/productImg/臻稚卓蓓/臻稚卓蓓_06.jpg`,
      `${version}/goodsDetail/productImg/臻稚卓蓓/臻稚卓蓓_07.jpg`,
      `${version}/goodsDetail/productImg/臻稚卓蓓/臻稚卓蓓_08.jpg`,
      `${version}/goodsDetail/productImg/臻稚卓蓓/臻稚卓蓓_09.jpg`,
      `${version}/goodsDetail/productImg/臻稚卓蓓/臻稚卓蓓_10.jpg`,
      `${version}/goodsDetail/productImg/臻稚卓蓓/臻稚卓蓓_11.jpg`,
      `${version}/goodsDetail/productImg/臻稚卓蓓/臻稚卓蓓_12.jpg`,
      `${version}/goodsDetail/productImg/臻稚卓蓓/臻稚卓蓓_13.jpg`,
      `${version}/goodsDetail/productImg/臻稚卓蓓/臻稚卓蓓_14.jpg`,
      `${version}/goodsDetail/productImg/臻稚卓蓓/臻稚卓蓓_15.jpg`,
      `${version}/goodsDetail/productImg/臻稚卓蓓/臻稚卓蓓_16.jpg`,
      `${version}/goodsDetail/productImg/臻稚卓蓓/臻稚卓蓓_17.jpg`,
      `${version}/goodsDetail/productImg/臻稚卓蓓/臻稚卓蓓_18.jpg`,
      `${version}/goodsDetail/productImg/臻稚卓蓓/臻稚卓蓓_19.jpg`
    ]
  },
  'chunrui_organic': {
    name: '淳芮有机',
    shareImage: `${version}/goodsDetail/shareImg/chunrui_organic.png`,
    shareText: '淳芮有机',
    productImages: [
      `${version}/goodsDetail/productImg/淳芮有机.png`
    ]
  },
  'xingfeifan_a2': {
    name: '星飞帆A2',
    shareImage: `${version}/goodsDetail/shareImg/xingfeifan_a2.png`,
    shareText: '星飞帆A2版',
    productImages: [
      `${version}/goodsDetail/productImg/星飞帆A2.png`
    ]
  },
  'xingfeifan_classic': {
    name: '星飞帆经典',
    shareImage: `${version}/goodsDetail/shareImg/xingfeifan_classic.png`,
    shareText: '星飞帆经典',
    productImages: [
      `${version}/goodsDetail/productImg/星飞帆经典.png`
    ]
  },
  'xingfeifan_digital': {
    name: '星飞帆数字化',
    shareImage: `${version}/goodsDetail/shareImg/xingfeifan_digital.png`,
    shareText: '星飞帆经典900g',
    productImages: [
      `${version}/goodsDetail/productImg/星飞帆数字化.png`
    ]
  },
  'xingfeifan_organic_a2_milk': {
    name: '星飞帆有机A2奶源版',
    shareImage: `${version}/goodsDetail/shareImg/xingfeifan_organic_a2_milk.png`,
    shareText: '星飞帆经典有机A2版',
    productImages: [
      `${version}/goodsDetail/productImg/星飞帆有机A2奶源版.png`
    ]
  },
  'xingfeifan_organic_milk': {
    name: '星飞帆有机奶源版',
    shareImage: `${version}/goodsDetail/shareImg/xingfeifan_organic_milk.png`,
    shareText: '星飞帆经典有机版',
    productImages: [
      `${version}/goodsDetail/productImg/星飞帆有机奶源版.png`
    ]
  },
  'xingfeifan_zhuochu': {
    name: '星飞帆卓初',
    shareImage: `${version}/goodsDetail/shareImg/xingfeifan_zhuochu.png`,
    shareText: '星飞帆卓初',
    productImages: [
      `${version}/goodsDetail/productImg/星飞帆卓初.png`
    ]
  },
  'xingfeifan_zhuoyao': {
    name: '星飞帆卓耀',
    shareImage: `${version}/goodsDetail/shareImg/xingfeifan_zhuoyao.png`,
    shareText: '星飞帆卓耀',
    productImages: [
      `${version}/goodsDetail/productImg/星飞帆卓耀.png`
    ]
  },
  'xingfeifan_zhuoyao_platinum_organic_a2': {
    name: '星飞帆卓耀铂金有机A2β-酪蛋白',
    shareImage: `${version}/goodsDetail/shareImg/xingfeifan_zhuoyao_platinum_organic_a2.png`,
    shareText: '星飞帆卓耀铂金',
    productImages: [
      `${version}/goodsDetail/productImg/星飞帆卓耀铂金.png`
    ]
  },
  'xingfeifan_zhuoyao_blue_diamond_organic': {
    name: '星飞帆卓耀蓝钻有机',
    shareImage: `${version}/goodsDetail/shareImg/xingfeifan_zhuoyao_blue_diamond_organic.png`,
    shareText: '星飞帆卓耀蓝钻',
    productImages: [
      `${version}/goodsDetail/productImg/星飞帆卓耀蓝钻有机.png`
    ]
  },
  'zhenzhi_zhuobei_a2': {
    name: '臻稚卓蓓A2β-酪蛋白Q',
    shareImage: `${version}/goodsDetail/shareImg/zhenzhi_zhuobei_a2.png`,
    shareText: '臻稚卓蓓A2',
    productImages: [
      `${version}/goodsDetail/productImg/臻稚卓蓓A2.png`
    ]
  }
}

// 产品名称数组
export const PRODUCT_NAMES = Object.values(PRODUCT_MAP).map(product => product.name)

// 产品ID数组
export const PRODUCT_IDS = Object.keys(PRODUCT_MAP)

// 根据产品名称获取产品ID
export const getProductIdByName = (name) => {
  const entry = Object.entries(PRODUCT_MAP).find(([_, product]) => product.name === name)
  return entry ? entry[0] : null
}

// 根据产品ID获取产品完整信息
export const getProductById = (id) => {
  return PRODUCT_MAP[id] || null
}

// 根据产品ID获取产品名称
export const getProductNameById = (id) => {
  const product = PRODUCT_MAP[id]
  return product ? product.name : null
}

// 根据产品ID获取分享图
export const getShareImageById = (id) => {
  const product = PRODUCT_MAP[id]
  return product ? product.shareImage : null
}

// 根据产品ID获取分享文案
export const getShareTextById = (id) => {
  const product = PRODUCT_MAP[id]
  return product ? product.shareText : null
}

// 根据产品ID获取产品图片数组
export const getProductImagesById = (id) => {
  const product = PRODUCT_MAP[id]
  return product ? product.productImages : []
}

// 获取所有产品的分享图片
export const getAllShareImages = () => {
  return Object.values(PRODUCT_MAP).map(product => product.shareImage)
}

// 获取所有产品图片（扁平化数组）
export const getAllProductImages = () => {
  return Object.values(PRODUCT_MAP).flatMap(product => product.productImages)
}

const rightsVersion = 'rights_v1'

// 权益页完整信息映射常量
export const RIGHTS_MAP = {
  'rights1': {
    name: '权益1',
    shareImage: `rights/${rightsVersion}/shareImg/rights1.jpg`,
    shareText: '飞鹤奶粉签收礼已送达！',
    productImages: [
      `rights/${rightsVersion}/bg/rights1.png`
    ]
  },
  'rights2': {
    name: '权益2',
    shareImage: `rights/${rightsVersion}/shareImg/rights_2.jpg`,
    shareText: '飞鹤省钱卡开卡立兑8包湿巾！',
    productImages: [
      `rights/${rightsVersion}/bg/rights2.png`
    ]
  },
  'rights3': {
    name: '权益3',
    shareImage: `rights/${rightsVersion}/shareImg/rights_3.png`,
    shareText: '飞鹤奶粉送您音频/视频会员卡！',
    productImages: [
      `rights/${rightsVersion}/bg/rights3.png`
    ]
  }
}

// 权益名称数组
export const RIGHTS_NAMES = Object.values(RIGHTS_MAP).map(rights => rights.name)

// 权益ID数组
export const RIGHTS_IDS = Object.keys(RIGHTS_MAP)

// 根据权益名称获取权益ID
export const getRightsIdByName = (name) => {
  const entry = Object.entries(RIGHTS_MAP).find(([_, rights]) => rights.name === name)
  return entry ? entry[0] : null
}

// 根据权益ID获取权益完整信息
export const getRightsById = (id) => {
  return RIGHTS_MAP[id] || null
}

// 根据权益ID获取权益名称
export const getRightsNameById = (id) => {
  const rights = RIGHTS_MAP[id]
  return rights ? rights.name : null
}

// 根据权益ID获取分享图
export const getRightsShareImageById = (id) => {
  const rights = RIGHTS_MAP[id]
  return rights ? rights.shareImage : null
}

// 根据权益ID获取分享文案
export const getRightsShareTextById = (id) => {
  const rights = RIGHTS_MAP[id]
  return rights ? rights.shareText : null
}

// 根据权益ID获取权益图片数组
export const getRightsImagesById = (id) => {
  const rights = RIGHTS_MAP[id]
  return rights ? rights.productImages : []
}

// 获取所有权益的分享图片
export const getAllRightsShareImages = () => {
  return Object.values(RIGHTS_MAP).map(rights => rights.shareImage)
}

// 获取所有权益图片（扁平化数组）
export const getAllRightsImages = () => {
  return Object.values(RIGHTS_MAP).flatMap(rights => rights.productImages)
}

// 权益按钮图片路径
export const rightsShareBtn = `rights/${rightsVersion}/shareBtn.png`