import requestModule from './request.js';
const {
	api
} = requestModule;

/**
 * 获取积分信息
 * @returns
 */

export const fetchIntegralJSON = () => api.get('/c/front/content',{type:'integral_V1'});

/**
 * 获取生日礼接口
 * @returns
 */
export const fetchBirthdayGiftJSON = () => api.get('/c/equity/birthdayGift/index');

/**
 * 领取生日礼
 * @returns
 */
export const fetchBatchReceiveJSON = () => api.post('/c/equity/birthdayGift/batchReceive');

/**
 * 获取活动状态--溯源游
 * @returns
 */
export const fetchActivityStateJSON = () => api.get('/c/third/activity/state');

//获取配置项和商品列表
export const getResourceList = () => api.get('/c/resource/list');

//获取签到和任务信息接口
export const getSigninAndTaskInfoJSON = () => api.get('/c/activity/todo/list');

//签到接口
export const checkInJSON = (activityId) => api.post('/c/activity/todo/checkIn', {activityId});

//获取秒杀列表
export const getSeckillList = () => api.get('/c/seckill/list');
//完成任务接口
export const taskCompleteJSON = (activityId) => api.post('/c/activity/todo/complete', { activityId });

//获取异业券接口
export const getPointsBenefitCouponJSON = () => api.get('/c/resource/pointsBenefit/coupon');

//查询任务结果接口
export const queryTodoResultJSON = (activityId) => api.get('/c/activity/todo/queryTodoResult');
