import { defineStore } from "pinia";
import { fetchRecordIndex, fetchRecordList, fetchFavoriteList, fetchRecordMyrecords } from "../api/xingmaLab.js";

export const useXingmaLabStore = defineStore("xingmaLab", {
  state: () => {
    return {
      // 星妈Lab接口返回的完整数据
      xingmaInfo: null,
      // 藏馆接口返回的完整数据
      cangguanInfo: null,
      // 收藏接口返回的完整数据
      shoucangInfo: null,
      // 藏品接口返回的完整数据
      cangpinInfo: null,
      // 加载状态（各接口独立）
      isLoadingIndex: false,
      isLoadingCangguan: false,
      isLoadingShoucang: false,
      isLoadingCangpin: false,
    };
  },
  actions: {
    /**
     * 获取星妈Lab数据
     */
    async loadXingmaInfo() {
      try {
        this.isLoadingIndex = true;
        const { data } = await fetchRecordIndex();
        console.log("xingmaInfo data", data);
        
        if (data) {
          this.xingmaInfo = data;
          console.log('保存的星妈Lab数据:', this.xingmaInfo);
        } else {
          console.log('星妈Lab数据格式不正确:', data);
        }
      } catch (error) {
        console.log('获取星妈Lab数据失败:', error);
      } finally {
        this.isLoadingIndex = false;
      }
    },

    /**
     * 获取藏馆数据
     */
    async loadCangguanInfo(pageIndex = 1, pageSize = 4) {
      try {
        this.isLoadingCangguan = true;
        const { data } = await fetchRecordList(pageIndex, pageSize);
        console.log("cangguanInfo data", data);
        
        if (data) {
          this.cangguanInfo = data;
          console.log('保存的藏馆数据:', this.cangguanInfo);
        } else {
          console.log('藏馆数据格式不正确:', data);
        }
      } catch (error) {
        console.log('获取藏馆数据失败:', error);
      } finally {
        this.isLoadingCangguan = false;
      }
    },

    /**
     * 获取收藏数据
     */
    async loadShoucangInfo(pageIndex = 1, pageSize = 4) {
      try {
        this.isLoadingShoucang = true;
        const { data } = await fetchFavoriteList(pageIndex, pageSize);
        console.log("shoucangInfo data", data);
        
        if (data) {
          this.shoucangInfo = data;
          console.log('保存的收藏数据:', this.shoucangInfo);
        } else {
          console.log('收藏数据格式不正确:', data);
        }
      } catch (error) {
        console.log('获取收藏数据失败:', error);
      } finally {
        this.isLoadingShoucang = false;
      }
    },

    /**
     * 获取藏品数据
     */
    async loadCangpinInfo(pageIndex = 1, pageSize = 8) {
      try {
        this.isLoadingCangpin = true;
        const { data } = await fetchRecordMyrecords(pageIndex, pageSize);
        console.log("cangpinInfo data", data);
        
        if (data) {
          this.cangpinInfo = data;
          console.log('保存的藏品数据:', this.cangpinInfo);
        } else {
          console.log('藏品数据格式不正确:', data);
        }
      } catch (error) {
        console.log('获取藏品数据失败:', error);
      } finally {
        this.isLoadingCangpin = false;
      }
    },

    /**
     * 重置星妈Lab数据
     */
    resetXingmaInfo() {
      this.xingmaInfo = null;
    },

    /**
     * 重置藏馆数据
     */
    resetCangguanInfo() {
      this.cangguanInfo = null;
    },

    /**
     * 重置收藏数据
     */
    resetShoucangInfo() {
      this.shoucangInfo = null;
    },

    /**
     * 重置藏品数据
     */
    resetCangpinInfo() {
      this.cangpinInfo = null;
    },

    /**
     * 获取星妈Lab数据
     */
    getXingmaInfo() {
      return this.xingmaInfo;
    },

    /**
     * 获取藏馆数据
     */
    getCangguanInfo() {
      return this.cangguanInfo;
    },

    /**
     * 获取收藏数据
     */
    getShoucangInfo() {
      return this.shoucangInfo;
    },

    /**
     * 获取藏品数据
     */
    getCangpinInfo() {
      return this.cangpinInfo;
    },
  },
});
