
//  Created by lc on 16/11/3.
//  Copyright © 2016年 Ta. All rights reserved.
//

#import "TaInfoStreamerView.h"
#import "TaTmHelper.h"

@interface TaInfoStreamerView () <UIWebViewDelegate>

@property (nonatomic,assign) BOOL reportedDisplay;

@property (nonatomic,strong) NSString *adslotId;
@property (nonatomic,strong) NSString *activityId;
@property (nonatomic,strong) NSString *requestId;
@property (nonatomic,strong) NSString *clickUrl;
@property (nonatomic,strong) UIWebView *webView;
@property(nonatomic, strong) NSDictionary* param;

@end

@implementation TaInfoStreamerView

+(instancetype)adViewWithOrigin:(CGPoint)origin
                       adslotId:(NSString*)adslotId
                           type:(TaInfoStreamType)type
           parentViewController:(UIViewController*)parentViewController
                   successBlock:(void(^)(void))success
                    failedBlock:(void(^)(void))failed
closedBlock:(void(^)(void))closed;
{
    if (!adslotId || adslotId.length == 0) {
        if (failed) {
            failed();
        }
    }
    parentViewController.automaticallyAdjustsScrollViewInsets= NO;
    CGFloat preferredWidth = Ta_SCREEN_WIDTH;
    CGFloat preferredHeight;
    if (type == TaInfoStreamTypeShort) {
         preferredHeight = ceilf(Ta_SCREEN_WIDTH * (180/750.0));
        TaInfoStreamerView *aView = [[TaInfoStreamerView alloc] initWithFrame:CGRectMake(origin.x, origin.y, preferredWidth, preferredHeight) successBlock:success failedBlock:failed closedBlock:closed];
        aView.adslotId = adslotId;
        aView.backgroundColor = [UIColor redColor];
        aView.parentViewController = parentViewController;
        [aView loadRequest];
        return aView;
    } else {
         preferredHeight = ceilf(Ta_SCREEN_WIDTH * (420/750.0));
        TaInfoStreamerView *aView = [[TaInfoStreamerView alloc] initWithFrame:CGRectMake(origin.x, origin.y, preferredWidth, preferredHeight) successBlock:success failedBlock:failed closedBlock:closed];
        aView.adslotId = adslotId;
        aView.backgroundColor = [UIColor redColor];
        aView.parentViewController = parentViewController;
        [aView loadRequest];
        return aView;
    }
    
    
    
}


-(instancetype)initWithFrame:(CGRect)frame
                successBlock:(void(^)(void))success
                 failedBlock:(void(^)(void))failed
closedBlock:(void(^)(void))closed;
{
    if (self = [super initWithFrame:frame]) {
        self.success = success;
        self.failed = failed;
        self.closed =closed;
        NSLog(@"self.bounds %@", NSStringFromCGRect(self.bounds));
        self.webView = [[UIWebView alloc] initWithFrame:self.bounds];
        UIView *webBrowserView = self.webView.scrollView.subviews[0];//拿webViewweb的BrowserView
        webBrowserView.frame = self.bounds;
        NSLog(@"webbrowserview.frame = %@", NSStringFromCGRect(webBrowserView.frame));
        self.webView.scrollView.alwaysBounceVertical = NO;
        self.webView.scrollView.alwaysBounceHorizontal = NO;
        self.webView.userInteractionEnabled = NO;
        [self addSubview:self.webView];
        self.webView.backgroundColor = [UIColor whiteColor];
        self.webView.delegate = self;
        self.alpha = 0;
        
        UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(tapped:)];
        [self addGestureRecognizer:tap];
    }
    return self;
}

-(void)loadRequest
{
    [super loadRequest];
    
    NSDictionary *parameters = @{@"adslot_id":self.adslotId};
    
    __weak TaInfoStreamerView *weakSelf = self;
    
    [TaTmHelper getActivitiesWithParameters:parameters successBlock:^(id resultObj) {
        
        self.param = resultObj;
        self.clickUrl = [resultObj objectForKey:@"click_url"];
        weakSelf.ad_title = [resultObj objectForKey:@"ad_title"];
        NSString *adContent = [resultObj objectForKey:@"ad_content"];
        
        //根据返回的字段确定是否加上关闭和广告字样
        NSNumber *ad_close_visible = resultObj[@"ad_close_visible"];
        if (!ad_close_visible) {
            ad_close_visible=@0;
        }
        NSDictionary *tmp =@{@"ad_close_visible":ad_close_visible,@"ad_icon_visible":@0};
        [TaUtils addIconForView:self paramter:tmp btn:@selector(closePress) caller:self];
        

        
        if (![adContent isKindOfClass:[NSNull class]]) {
            //加载传过来的html 字符串。暂时不可用
            //if (adContent.length > 0) {
                [weakSelf.webView loadHTMLString:adContent baseURL:nil];
            //}
        } else {
            
        }
    } failedBlock:^(id resultObj) {
        if (weakSelf.failed) {
            weakSelf.failed();
        }
    }];
}

- (void)webViewDidFinishLoad:(UIWebView *)webView
{
    if (self.success) {
        self.success();
    }
    self.canTap = YES;
    if (!self.reportedDisplay) {

        [TaTmHelper displayAdWithParam:self.param];
        self.reportedDisplay = YES;
    }
    [UIView animateWithDuration:0.25 animations:^{
        self.alpha = 1;
    }];
}

-(void)tapped:(UITapGestureRecognizer*)tap
{
    if (self.canTap) {


        [TaTmHelper clickAdWithParam:self.param];
        TaSimpleWebViewController *web = [TaSimpleWebViewController new];
        web.url = self.clickUrl;
        web.ad_title = self.ad_title;
        if (self.parentViewController.navigationController.topViewController == self.parentViewController) {
            NSLog(@"push");
            UIBarButtonItem *item = [[UIBarButtonItem alloc] initWithTitle:@"返回" style:UIBarButtonItemStylePlain target:nil action:nil];
            self.parentViewController.navigationItem.backBarButtonItem = item;
            [self.parentViewController.navigationController pushViewController:web animated:YES];
        }else{
            NSLog(@"present");
            UINavigationController* navi = [[UINavigationController alloc]initWithRootViewController:web];
            [self.parentViewController presentViewController:navi animated:YES completion:nil];
        }

    }
}
-(void)closePress{
   
    if (self.closed) {
        self.closed();
    }
     [self removeFromSuperview];
}
@end
