//
//  TaSimpleWebViewController.m
//  AdIOSSDK
//
//  Created by lc on 16/11/6.
//  Copyright © 2016年 Ta. All rights reserved.
//

#import "TaSimpleWebViewController.h"
#import "UIViewController+DZBackButtonHandler.h"
#import "TaTmHelper.h"

@interface TaSimpleWebViewController () <UIWebViewDelegate>

@property (nonatomic,strong) UIWebView *webView;

@end

@implementation TaSimpleWebViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = self.ad_title;
    self.view.backgroundColor = [UIColor whiteColor];
    
    self.webView = [[UIWebView alloc] initWithFrame:CGRectMake(0, 0, self.view.bounds.size.width, self.view.bounds.size.height)];
    //self.webView.alpha = 0;
    self.webView.delegate = self;
    [self.webView loadRequest:[NSURLRequest requestWithURL:[NSURL URLWithString:self.url]]];
    [self.view addSubview:self.webView];
    
    NSArray *viewcontrollers=self.navigationController.viewControllers;
    if (viewcontrollers.count>1) {
        if ([viewcontrollers objectAtIndex:viewcontrollers.count-1]==self) {
            //push方式
        }
    }
    else{
        //present方式
        self.navigationItem.leftBarButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"< 返回" style:UIBarButtonItemStylePlain target:self action:@selector(returnPress:)];
    }
    
    
    
   /* UIButton* button = [UIButton buttonWithType:UIButtonTypeCustom];
    [button addTarget:self action:@selector(returnPress:) forControlEvents:UIControlEventTouchUpInside];
    button.frame = CGRectMake(0, 0, 45, 25);
    [button setImage:[UIImage imageNamed:@"返回.png"] forState:UIControlStateNormal];
    self.navigationItem.leftBarButtonItem = [[UIBarButtonItem alloc]initWithCustomView:button];
    self.navigationItem.leftBarButtonItem.imageInsets = UIEdgeInsetsMake(12, -8, 10, 60);*/
    // Do any additional setup after loading the view.
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)webViewDidFinishLoad:(UIWebView *)webView
{
    self.title = [self.webView stringByEvaluatingJavaScriptFromString:@"document.title"];

    if (self.finished) {
        self.finished();
    }
//    [UIView animateWithDuration:0.25 animations:^{
//        self.webView.alpha = 1;
//    }];
}
- (BOOL)navigationShouldPopOnBackButton{
    if (self.webView.canGoBack) {
        [self.webView goBack];
        return NO;
    } else {
        return YES;
    }
}
-(void)returnPress:(id)sender{
    if (self.webView.canGoBack) {
        [self.webView goBack];
        
    }else{
        if ([TaTmHelper helper].closeLaunchADView) {
            [TaTmHelper helper].closeLaunchADView();
        }
        
        [self dismissViewControllerAnimated:YES completion:nil];
    }
    

}
@end
