import ComponentBase from "../components/ComponentBase";
import Loading from "../loading/Loading";
import { MUtils } from "../MUtils";

export default class Scene extends ComponentBase {
    public onSkinLoaded: () => void;

    preLoadRes() {
        if (this.groupName) {
            return RES.loadGroup(this.groupName);
        } else {
            return null;
        }
    }

    protected onSkinComplete() {
        super.onSkinComplete();
        this.onSkinLoaded && this.onSkinLoaded();
        let scaler = document.body.clientWidth / 750;
        let ratio = document.body.clientHeight / (1200 * scaler);
        if (ratio < 1) {
            let fixArea = (this["fixArea"] as eui.Component);
            fixArea.scaleX = ratio;
            fixArea.scaleY = ratio;
            MUtils.fixAreaRatio = ratio;

        }
    }
}