export const getResPath = () => window['resPath'] || '';
export const getSkinPath = (key: any) => `resource/skins/${key}Skin.exml`

export let shareImg: HTMLElement = null;
let scrolleEvent = false;
let touchMove = false;

export function setShareImg(imgUrl: string, rect: egret.Rectangle, padding: number, visible: boolean = true) {
    shareImg = shareImg || document.getElementById('shareImg');
    shareImg.style.position = 'absolute';
    shareImg.style.display = 'block';
    shareImg.style.visibility = "visible";
    shareImg.style.opacity = visible ? "1" : "0";
    let scaler = document.body.clientWidth / 750;
    let gameScroller = getGameScroller();
    shareImg.style.width = (scaler * rect.width).toString() + "px";
    shareImg.style.height = (scaler * rect.height).toString() + "px";
    shareImg.style.padding = padding.toString() + "px";
    // shareImg.style.width = "252px";
    // shareImg.style.height = "252px";
    /* if (gameScroller) {
        shareImg.style.top = ((rect.y - gameScroller.viewport.scrollV) * scaler).toString() + "px";
    } else {
        shareImg.style.top = (rect.y * scaler).toString() + "px";
    } */
    shareImg.style.top = ((rect.y * scaler) - padding).toString() + "px";
    shareImg.style.left = ((rect.x * scaler) - padding).toString() + "px";
    shareImg['src'] = imgUrl;

    /* if (!scrolleEvent && gameScroller) {
        scrolleEvent = true;
        gameScroller.addEventListener(egret.Event.CHANGE, () => {
            shareImg.style.top = ((rect.y - gameScroller.viewport.scrollV) * scaler).toString() + "px";
        }, this);
    }

    if (!touchMove) {
        touchMove = true;
        shareImg.onmousedown = (p2) => {
            // shareImg.style.visibility = "hidden";
            shareImg.style.pointerEvents = "none";

            console.error(p2);
        }
        shareImg.onmouseup = (p2) => {
            delete shareImg.style.pointerEvents;
            console.error(p2);
        }
    } */
}
export function clearShareImg() {
    if (!shareImg) {
        console.log("shareImg is null");
        return;
    }

    shareImg.style.width = "0px";
    shareImg.style.height = "0px";
    shareImg.style.visibility = "hidden";
}

let gameScroller: eui.Scroller = null;
export function getGameScroller() {
    return gameScroller;
}
export function setGameScroller(v: eui.Scroller) {
    gameScroller = v;
}