import Scene from "../views/Scene";
import Loading from "../loading/Loading";
export default class SceneCtrl {
    private _parent: egret.DisplayObjectContainer;
    private _currentScene: Scene;

    static _instance: SceneCtrl;
    static get instance() {
        return SceneCtrl._instance || (SceneCtrl._instance = new SceneCtrl())
    }
    init(parent: egret.DisplayObjectContainer) {
        this._parent = parent;
    }

    change(cls: any, data?: any) {
        const scene: Scene = new cls(data);
        this._parent.addChild(scene);

        scene.onSkinLoaded = () => {
            if (this._currentScene) {
                this._currentScene.destroy();
                this._parent.removeChild(this._currentScene);
            }
            this._currentScene = scene;
        }
    }
}