import Panel from "../views/Panel";

export default class ToastPanel extends Panel {
    public msgLb:eui.Label;
    public bgRect:eui.Rect;

    private mdata:any;
    public get skinKey() { return 'ToastPanel' }

    start(data) {
        this.mdata = data;
        this.percentHeight = 100;

    }

    onSkinComplete() {
        super.onSkinComplete();
        this.pMask.visible = false;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    initEvents() {
        super.initEvents();
        // this.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_this, this);

    }

    removeEvents() {
        super.removeEvents();
        // this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_this, this);
    }

    private onLoad():void{
        if(this.mdata){
            // if(this.mdata.line > 2){
            //     this.bgRect.height = 150 + (this.mdata.line - 2) * 30;
            // }
            this.msgLb.text = this.mdata.msg;

            // if(this.mdata.width){
            //     this.bgRect.width = this.mdata.width;
            // }

            // if(this.mdata.height){
            //     this.bgRect.height = this.mdata.height;
            // }
        }
        
        setTimeout(function(){
            egret.Tween.get(this).to({alpha:0}, 500, egret.Ease.quintOut).call(function(){
                this.onTouchTap();
            }.bind(this));
        }.bind(this), 1500);
        
    }

}