import IScene from "./IScene";
import { MTimer } from "../Game/GameObject";
import { Decorator } from "../Decorator/Decorator";

@Decorator.OnDestroy
export default class Scene extends eui.Component implements IScene {
    public onSceneLoaded = () => { }
    private timerList: MTimer[] = [];

    constructor() {
        super();
        this.left = 0;
        this.right = 0;
        this.top = 0;
        this.bottom = 0;
    }

    /**@override */
    onDestroy() {
        this.timerList.forEach(e => e.destroy());
        this.timerList = null;
    }

    public setTimer(time: number, onTimeOut: () => void, repeat?: number, onRepeated?: () => void): MTimer {
        let timer = new MTimer(time, onTimeOut, repeat, () => {
            onRepeated && onRepeated();
            //执行完毕，在列表中删除自身
            this.timerList.splice(this.timerList.indexOf(timer), 1);
        });
        this.timerList.push(timer);
        return timer;
    }
}