import { Decorator } from "../Decorator/Decorator";

// @Decorator.Skin("ProgressBar")
export default class ProgressBar extends eui.Component {
    constructor() {
        super();
        this.skinName = `<?xml version="1.0" encoding="utf-8"?>
        <e:Skin class="ProgressBar" xmlns:e="http://ns.egret.com/eui" xmlns:w="http://ns.egret.com/wing">
            <e:Group>
                <e:Image source="load_progress_bg_png" scaleX="1" scaleY="1" />
                <e:Group x="2" y="2" scaleX="1" scaleY="1">
                    <e:Image id="fill" source="load_progress_fill_png" anchorOffsetX="0" scaleX="1" scaleY="1"
                             cacheAsBitmap="false"  width="656"/>
                    <e:Image id="mask" source="load_progress_fill_png" anchorOffsetX="0"
                             cacheAsBitmap="false"  scale9Grid="31,4,591,28"/>
                </e:Group>
            </e:Group>
        </e:Skin>`;
        this.fill.mask = this.mask;
    }

    public fill: eui.Image;
    public mask: eui.Image;


    private _value: number = 0.5;

    /**区间[0,1] */
    public get value() {
        return this._value;
    }
    public set value(v: number) {
        if (v < 0) v = 0;
        if (v > 1) v = 1;

        this._value = v;
        (this.fill.mask as egret.DisplayObject).width = this.fill.width * v; //皮肤中要显示指定fill的width，不然开始时会获取不到width
    }
}