import SkinScene from "../views/SkinScene";
import { Decorator } from "../Decorator/Decorator";
import SceneCtrl from "../ctrls/SceneCtrl";
import MainScene from "./MainScene";
import Ant from "../Game/Ant";
import DisplayCollider, { Tag } from "../Game/DisplayCollider";
import { MConst } from "../MConst";
import PlayerController, { ControllerDirection } from "../Game/PlayerController";
import PhysicalSystem from "../Game/PhysicalSystem";
import GoldCoin from "../Game/GoldCoin";
import Scene from "../components/Scene";
import GameMgr from "../Mgr/GameMgr";

@Decorator.OnUpdate
export default class StartScene extends Scene {
    private gameStage: egret.DisplayObjectContainer = null;
    private ant: Ant = null;

    constructor() {
        super();

        let bg = new eui.Image(RES.getRes("start_bg_jpg"));
        this.addChild(bg);

        this.gameStage = new egret.DisplayObjectContainer();
        this.addChild(this.gameStage);

        let ui = new StartSceneUI();
        this.addChild(ui);
        ui.onLoaded = () => {
            this.onSceneLoaded();
            this.playGameDemo();
        }
    }

    private playGameDemo() {
        //创建地面碰撞器
        let groundCollider = new DisplayCollider(Tag.Ground, MConst.GroundLocalRect);
        this.gameStage.addChild(groundCollider);
        //创建蚂蚁
        let ant = new Ant();
        this.gameStage.addChild(ant);
        ant.land(400);
        this.ant = ant;
        this.antAct();
    }

    private antAct() {
        //创建金币
        let goldCoin1 = new GoldCoin();
        goldCoin1.land(1200, -700);
        this.gameStage.addChild(goldCoin1);

        this.ant.setTimer(1000, async () => {
            await this.goToEatGoldCoin(goldCoin1);
            this.ant.move(ControllerDirection.None);

            let goldCoin2 = new GoldCoin();
            goldCoin2.land(400, -600);
            this.gameStage.addChild(goldCoin2);

            await this.ant.delay(1000);
            await this.goToEatGoldCoin(goldCoin2);
            this.ant.move(ControllerDirection.None);
        });
    }

    private goToEatGoldCoin(goldCoin: GoldCoin) {
        if (goldCoin.x > this.ant.x) {
            this.ant.move(ControllerDirection.Right);
        } else {
            this.ant.move(ControllerDirection.Left);
        }

        return new Promise<void>(resolve => {
            goldCoin.addEventListener(egret.Event.REMOVED_FROM_STAGE, async () => {
                await this.ant.delay(200);
                resolve()
            }, this);
        });
    }

    onUpdate() {
        //物理引擎运行
        PhysicalSystem.instance.detectCollision();
    }
}

@Decorator.Skin("StartSceneUI")
class StartSceneUI extends eui.Component {
    public btnLogin: eui.Button;
    public btnStart: eui.Button;
    public btnRank: eui.Button;
    public btnRule: eui.Button;
    public btnRecord: eui.Button;
    public btnSound: eui.Button;
    public labelFreeTime: eui.Label;
    public labelMyCredit: eui.Label;

    public onLoaded = () => { };

    onSkinComplete() {
        this.btnStart.onTap(this, () => {
            SceneCtrl.instance.change(MainScene);
        });

        this.onLoaded();
    }
}