import SkinScene from "../views/SkinScene";
import SceneCtrl from "../ctrls/SceneCtrl";
import StartScene from "./StartScene";
import ProgressBar from "../components/ProgressBar";
import { Decorator } from "../Decorator/Decorator";

@Decorator.OnUpdate
export default class extends SkinScene {
    get skinKey() { return "LoadScene" }
    private progress: ProgressBar = null;

    onSkinComplete() {
        super.onSkinComplete();
        let progress = new ProgressBar();
        this.addChild(progress);
        progress.horizontalCenter = 3;
        progress.verticalCenter = 68;
        this.progress = progress;
        this.loadRes();
    }

    async loadRes() {
        await RES.loadGroup("main_res");
        await RES.loadGroup("start_scene");
        this.progress.value = 0;
        setTimeout(async () => {
            this.progress.value = 0.5;
            setTimeout(async () => {
                this.progress.value = 1;
                setTimeout(() => {
                    SceneCtrl.instance.change(StartScene);
                }, 500);
            }, 500);
        }, 500);
    }

    onUpdate() {
        // console.error(1);
    }
}