import { Decorator } from "./Decorator/Decorator";
import Panel from "./views/Panel";
import { DataManager } from "../libs/tw/manager/DataManager";
import { HtmlTextParser } from "../libs/tc/util/HtmlTextParser";
import { shareImg } from "./utils";

export default class RulePanel extends Panel {
  get skinKey() { return "RulePanel" }
  get groupName() { return "rule_panel" }
  public closeBtn: eui.Button;
  public text: eui.Label;

  constructor() {
    super();
    this.top = 0
    this.left = 0
    this.right = 0
    this.bottom = 0;
    shareImg && (shareImg.style.visibility = "hidden");
  }

  onSkinComplete() {
    super.onSkinComplete();
    this.closeBtn.onTap(this, () => {
      this.hidePanel();
      shareImg && (shareImg.style.visibility = "visible");
    });
    //TODO
    // this.text.text = text;
    this.text.textFlow = new HtmlTextParser().parse(DataManager.ins.ajaxElementData.rule);
  }
}

let text =
  `！！！！！注意！！！！！我不是这个活动的弹窗！！
活动细则： 
1、活动时间：2019年9月19日-2019年10月16日 。
2、活动对象：已激活并绑定微信版屈臣氏会员卡的会员，并关注【屈臣氏服务助手】 。
3、参与条件：会员在屈臣氏大陆所有门店单笔消费满200元（购买会员卡、Fun享卡除外）或消耗9积分可获1次抽奖机会，每张小票最多抽奖1次。
4、活动奖品：
  （1）携程礼品卡/无门槛通兑券：
    1000元携程任我行礼品卡，共20张；
    200元携程无门槛通兑券，共50张；
    100元携程无门槛通兑券，共70张；
    50元携程无门槛通兑券，共860张；
  （2）ITO品牌旅行箱包/天猫满减券：
    ITO20寸小黄箱（价值988元），共2个；
    ITO20寸森绿箱（价值988元），共10个；
    ITO 14寸无边界双肩包（价值498元），共7个；
    ITO首饰收纳包Mini小黄箱（价值288元）共4个；
    ITO无边界斜挎包（价值218元），共16个；
    ITO天猫满200-100元优惠券，共2000张；
  （3）屈臣氏干湿分离运动抽绳背包发带套装（价值129元），共10000份；
  （4）君亭酒店集团铂金卡（92折），共20000份；
  （5）美团酒店40元礼包，共20000份。
  （6）积分券：
    18积分，共20000份；
    28积分，共10000份；
    38积分，共9000份；
    88积分，共6000份；
    188积分，共4000份。
5、携程礼品卡/无门槛通兑券/君亭酒店集团铂金卡（92折）/美团酒店40元礼包将以券码形式发放，具体兑换说明及使用说明请前往【我的奖品】查看；
6、ITO品牌旅行箱包将以快递形式发放，中奖用户要登记真实姓名、手机号码、快递地址等信息，在中奖后15个工作日内以短信方式通知您奖品快递单号，如快递过程中出现损失获破损，不补不换。
7、ITO品牌天猫满199-100元券需中奖用户复制券号至天猫APP领取使用，具体使用说明请前往【我的奖品】查看；
8、屈臣氏干湿分离运动抽绳背包发带套装需中奖用户凭中奖码至屈臣氏门店领取，领取有效期为2019年9月19日-10月16日，一经领取不退不换，逾期视为放弃领取；
9、积分券中奖后在屈臣氏门店任意消费凭券核销券码，积分自动计入积分账户，具体使用说明请前往【我的奖品】查看；
10、在本次活动期间，如用户存在任何违反法律、法规、屈臣氏活动规则的行为，包括但不限于作弊得奖、恶意套现等行为，屈臣氏有权取消用户的中奖资格，收回所发奖品，要求用户将已享受的优惠退还屈臣氏，如奖品为实体奖品且用户已拆除外包装无法进行二次销售的，屈臣氏有权按照奖品的市场价格向用户追讨。
11、本次活动规则如有调整，以活动H5页面最新提示为准。因可能存在的系统缓存、页面更新导致页面显示异常等不确定性情况出现，如您发现会员活动或者促销信息有异常或对活动有任何疑问，请致电服务热线：4008301310（自付市内话费）`