import Panel from "../views/Panel";
import { Decorator } from "../Decorator/Decorator";

export default class WinningPanel extends Panel {
    get skinKey() { return "WinningPanel" }
    get groupName() { return "winning_panel" }
    @Decorator.LightRotate(0.7)
    public light: eui.Image;
    public score: eui.Label;
    public btnRestart: eui.Button;
    public btnReceive: eui.Button;
    public labelHighestScore: eui.Label;

    onSkinComplete() {
        super.onSkinComplete();

        let callback = () => {
            egret.Tween.get(this.light).to({ rotation: 360 }, 8000).call(callback);
        }
        callback();
    }

}