import { NetManager } from "../libs/tw/manager/NetManager";
import { DataManager } from "../libs/tw/manager/DataManager";
import PanelCtrl from "./ctrls/PanelCtrl";
import ToastPanel from "./components/ToastPanel";

export default class Net {
    public static sendGet(uri: string, param: any, onSuccess: (res: any) => void, onFail?: (res: any) => void, pollingCheck?: (res: any) => boolean, pollingCount?: number) {
        this.mSend("get", uri, param, onSuccess, onFail, pollingCheck, pollingCount);
    }
    public static sendPost(uri: string, param: any, onSuccess: (res: any) => void, onFail?: (res: any) => void, pollingCheck?: (res: any) => boolean, pollingCount?: number) {
        this.mSend("post", uri, param, onSuccess, onFail, pollingCheck, pollingCount);
    }
    private static mSend(type: string, uri: string, param: any, onSuccess: (res: any) => void, onFail?: (res: any) => void, pollingCheck?: (res: any) => boolean, pollingCount?: number) {
        NetManager.ins.send({
            name: uri,
            uri: uri,
            type: type,
            dataType: 'json',
            param: param,
            callback: (e: any) => {
                let res = DataManager.ins.getData(uri);
                if (e) {
                    console.log("response", uri, res);
                    onSuccess(res);
                } else {
                    console.warn("response", uri, res);
                    PanelCtrl.instance.show(ToastPanel, { msg: (res && (res["desc"] || res["message"])) || "network error" });
                    onFail && onFail(res);
                }
            },
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        });
        console.log("requset", uri, param);
    }

    public static readonly Url = {
        GetWXUserState: "/wechatThirdParty/getWechatUserNew",
        TEST: "/projectx/3/w624c4da9/a47972bc4.do"
    }
}