import GameMgr from "./GameMgr";
import Leg from "../Game/Leg";

export default class DebugMgr extends egret.DisplayObjectContainer {
    private shapeMap = {};
    private graphicDebugLayer: egret.DisplayObjectContainer = null;
    private uiLayer: eui.UILayer = null;
    private log: eui.Label = null;

    public onClick = () => { }

    public t: any = null;

    constructor() {
        super();
        //创建图形调试层
        this.graphicDebugLayer = new egret.DisplayObjectContainer();
        this.graphicDebugLayer.touchEnabled = false;
        this.addChild(this.graphicDebugLayer);
        //创建UI层
        this.uiLayer = new eui.UILayer();
        this.uiLayer.touchThrough = true;
        this.addChild(this.uiLayer);
        //创建日志标签
        this.log = new eui.Label("Log");
        this.log.horizontalCenter = 0;
        this.log.top = 50;
        this.log.textColor = 0xffffff;
        this.log.stroke = 0.5;
        this.log.size = 32;
        this.uiLayer.addChild(this.log);
        //创建调试按钮
        let button = new eui.Label("调试");
        button.textColor = 0x000000;
        button.borderColor = 0x000000;
        button.border = true;
        button.top = 30;
        button.right = 50;
        this.uiLayer.addChild(button);
        button.onTap(this, () => {
            this.onClick();
        });
    }

    public setLog(msg: string) {
        this.log.text = msg;
    }

    public drawCollider(rect: egret.Rectangle, style: GraphicDebug.Style = { color: 0xff0000, lineSize: 1 }) {
        let shape = new egret.Shape();
        shape.graphics.lineStyle(style.lineSize, style.color);
        shape.graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
        this.graphicDebugLayer.addChild(shape);
    }

    public drawLine(line: GraphicDebug.Line, style: GraphicDebug.Style = { color: 0xff0000, lineSize: 1 }) {
        let shape = new egret.Shape();
        shape.graphics.lineStyle(style.lineSize, style.color);
        shape.graphics.moveTo(line.startX, line.startY);
        shape.graphics.lineTo(line.endX, line.endY);
        this.graphicDebugLayer.addChild(shape);
    }

    public updateLine(key: string, line: GraphicDebug.Line, style: GraphicDebug.Style = { color: 0xff0000, lineSize: 1 }) {
        let shape: egret.Shape = this.shapeMap[key];
        if (!shape) {
            shape = new egret.Shape();
            this.graphicDebugLayer.addChild(shape);
            this.shapeMap[key] = shape;
        }

        shape.graphics.clear();
        shape.graphics.lineStyle(style.lineSize, style.color);
        shape.graphics.moveTo(line.startX, line.startY);
        shape.graphics.lineTo(line.endX, line.endY);
    }

    public updateCollider(key: string, rect: egret.Rectangle, style: GraphicDebug.Style = { color: 0xff0000, lineSize: 1 }) {
        let shape: egret.Shape = this.shapeMap[key];
        if (!shape) {
            shape = new egret.Shape();
            this.graphicDebugLayer.addChild(shape);
            this.shapeMap[key] = shape;
        }

        shape.graphics.clear();
        shape.graphics.lineStyle(style.lineSize, style.color);
        shape.graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
    }

    public clearCollider(key: string) {
        let shape: egret.Shape = this.shapeMap[key];
        if (!shape) {
            console.warn("collider is nonexistent");
            return;
        }

        delete this.shapeMap[key];
        shape.destroy();
    }

    private static _instance: DebugMgr = null;
    public static get instance(): DebugMgr {
        if (!this._instance) {
            if (GameMgr.instance.stage) {
                this._instance = new DebugMgr();
                GameMgr.instance.stage.addChild(this._instance);
            } else {
                console.error("stage is null,DebugMgr can not instantiate");
            }
        }

        return this._instance;
    }
}

export namespace GraphicDebug {
    export interface Style {
        color: number;
        lineSize: number;
    }
    export interface Line {
        startX: number;
        startY: number;
        endX: number;
        endY: number;
    }
}


