import AssetAdapter from "./AssetAdapter";
import PanelCtrl from "./ctrls/PanelCtrl";
import SceneCtrl from "./ctrls/SceneCtrl";
import Loading from "./loading/Loading";
import ThemeAdapter from "./ThemeAdapter";
import layers from "./views/layers";
import { Buried } from '../libs/tw/util/Buried';
import TopLayerCtrl from './ctrls/TopLayerCtrl';
import { getResPath, setGameScroller, shareImg } from "./utils";
import Scene from "./views/Scene";
import { customClassPrototype } from "./components/Custom";
import AnswerScene from "./Scene/AnswerScene";
import MainScene from "./Scene/MainScene";
import { NetManager } from "../libs/tw/manager/NetManager";
import { DataManager } from "../libs/tw/manager/DataManager";
import ToastPanel from "./components/ToastPanel";

class Main extends eui.UILayer {
    protected createChildren(): void {
        super.createChildren();

        //inject the custom material parser
        //注入自定义的素材解析器
        let assetAdapter = new AssetAdapter();
        egret.registerImplementation("eui.IAssetAdapter", assetAdapter);
        egret.registerImplementation("eui.IThemeAdapter", new ThemeAdapter());

        egret.ImageLoader.crossOrigin = "anonymous";
        layers.init(this);

        Loading.init(layers.topLayer);
        PanelCtrl.instance.init(layers.popupLayer);
        SceneCtrl.instance.init(layers.sceneLayer);
        TopLayerCtrl.instance.init(layers.topLayer);

        Buried.init();

        this.stage.scaleMode = egret.StageScaleMode.FIXED_WIDTH;

        this.runGame().catch(e => {
            console.log(e);
        });

        // layers.scrollEnabled = true;
        // layers.scrollRect = new egret.Rectangle(0, 0, document.body.clientWidth, document.body.clientHeight);
        this.stage.addEventListener(egret.TouchEvent.TOUCH_END, () => {
            if (shareImg) {
                // shareImg.style.visibility = "visible";
                delete shareImg.style.pointerEvents;
            }
        }, this);
    }

    private async runGame() {
        await this.loadResource()
        this.createGameScene();
    }

    private async loadResource() {
        try {
            await RES.loadConfig("default.res.json", getResPath() + "resource/");
            await this.loadTheme();
        }
        catch (e) {
            console.error(e);
        }
    }

    private loadTheme() {
        return new Promise((resolve, reject) => {
            // load skin theme configuration file, you can manually modify the file. And replace the default skin.
            //加载皮肤主题配置文件,可以手动修改这个文件。替换默认皮肤。
            let theme = new eui.Theme("resource/default.thm.json", this.stage);
            theme.addEventListener(eui.UIEvent.COMPLETE, () => {
                resolve();
            }, this);

        })
    }

    private textfield: egret.TextField;
    /**
     * 创建场景界面
     * Create scene interface
     */
    protected createGameScene(): void {

        this.getGameRes();
    }

    //加载游戏中的资源
    private async getGameRes() {
        DataManager.ins.customCfgData = window["CFG"];
        NetManager.ins.ajaxElement((success) => {
            if (!success) {
                return;
            }
            SceneCtrl.instance.change(MainScene);
        })

    }
}

window['Main'] = Main;
customClassPrototype();
