import Ant from "./Ant";

export default class PlayerController extends eui.UILayer {
    constructor() {
        super();
        this.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onTouchBegin, this);
        this.addEventListener(egret.TouchEvent.TOUCH_END, this.onTouchEnd, this);
    }
    public direction: ControllerDirection = ControllerDirection.None;

    public onLeft: () => void = () => { };
    public onRight: () => void = () => { };

    private onTouchBegin(event: egret.TouchEvent) {
        if (event.stageX >= this.stage.stageWidth / 2) {
            this.direction = ControllerDirection.Right;
        } else {
            this.direction = ControllerDirection.Left;
        }
    }

    private onTouchEnd() {
        this.direction = ControllerDirection.None;
    }
}

export enum ControllerDirection {
    None,
    Left,
    Right
}