import GameObject from "./GameObject";
import { MConst } from "../MConst";
import { MConfigs } from "../MConfigs";
import DisplayCollider, { Tag } from "./DisplayCollider";
import DebugMgr from "../Mgr/DebugMgr";
import GameMgr from "../Mgr/GameMgr";
import { Decorator } from "../Decorator/Decorator";
import GameStage from "./GameStage";

export default class Leg extends GameObject {
    private acting = false;
    public toward: LegToward;
    public get towardCoefficient() { return this.toward == LegToward.Right ? 1 : -1; }
    private gameStage: GameStage = null;

    constructor(gameStage: GameStage, rect: egret.Rectangle, texture: egret.Texture, toward: LegToward) {
        super(Tag.Leg, rect);
        this.gameStage = gameStage;
        let bitmap = new egret.Bitmap(texture);
        this.addChild(bitmap);
        this.toward = toward;

        if (toward == LegToward.Left) {
            bitmap.scaleX = -1;
            this.localRect = new egret.Rectangle(
                -(this.localRect.x + this.localRect.width),
                this.localRect.y,
                this.localRect.width,
                this.localRect.height
            );
        }

    }

    public updateCallback = () => { }
    onUpdate() {
        super.onUpdate();
        this.updateCallback();
    }

    protected onDraw(): void { }

    /**一次行动完毕的回调 */
    public onActed: () => void = () => { }

    /**行动 */
    public act() {
        this.acting = true;
        this.doTween();
    }
    private stopAct() {
        this.acting = false;
        egret.Tween.removeTweens(this);
        this.velocity = new egret.Point();

        //震动地面
        this.gameStage.shake().then(() => {
            this.onActed();
        });
    }

    private doTween() {
        let param = MConfigs.legTweenParam;
        egret.Tween.get(this.velocity)
            .to({ y: -param.rise.maxSpeed }, param.rise.duration.speedUp)
            .wait(param.rise.duration.keep)
            .to({ y: 0 }, param.rise.duration.slowDown)
            .to({ y: param.fall.speedUp1.value }, param.fall.speedUp1.duration)
            .to({ y: param.fall.speedUp2.value }, param.fall.speedUp2.duration);

        let p1Time = param.rise.duration.speedUp
            + param.rise.duration.keep
            + param.rise.duration.slowDown
        let p2Time = param.fall.speedUp1.duration
            + param.fall.speedUp2.duration;
        egret.Tween.get(this.velocity)
            .to({ x: 5 * this.towardCoefficient }, p1Time)
            .to({ x: 8 * this.towardCoefficient }, p2Time);
    }

    /**@override */
    onCollisionEnter(other: DisplayCollider) {
        if (other.tag == Tag.Ground && this.acting) {
            this.stopAct();
        }

        if (other.tag == Tag.Ant) {
            if (this.acting) {
                // GameMgr.instance.ant.die();
            }
        }
    }

    /**@override */
    onCollisionStay(other: DisplayCollider) {
    }

    /**@override */
    onCollisionExit(other: DisplayCollider) {

    }
}

export enum LegToward {
    Left,
    Right
}