import GameObject from "./GameObject";
import DisplayCollider, { Tag, Contact } from "./DisplayCollider";
import { MConst } from "../MConst";
import { Decorator } from "../Decorator/Decorator";
import { MConfigs } from "../MConfigs";
import GameMgr from "../Mgr/GameMgr";
import MainScene from "../Scene/MainScene";

export default class GoldCoin extends GameObject {
    /**标识是否落地。这个落地不是只接触了地面，而是弹跳完毕，完全落在地面上。 */
    private onGround = false;
    /**标识是否被脚踩 */
    private beTrampled = false;
    private contactGroundFrameCount = 0;
    private bounceCoefficient = 1;
    private context: MainScene = null;
    private scoreValue = 10;

    constructor(context?: MainScene) {
        super(Tag.GoldCoin, MConst.GoldCoinLocalRect);
        this.context = context || null;
        this.bounceCoefficient = MConfigs.goldCoin.bounceCoefficient;
        this.acceleration.y = MConfigs.goldCoin.gravity;
    }
    /**@override */
    onDraw() {
        this.addChild(new egret.Bitmap(RES.getRes("gold_coin_png")));
    }

    onCollisionEnter(other: DisplayCollider, contact: Contact) {
        if (other.tag == Tag.Leg) { //被踩
            if (!this.onGround) { //在空中被踩
                //给予垂直速度增量
                this.velocity.y += MConfigs.goldCoin.moveVelocityY;
                this.bounceCoefficient = 0;
            } else { //在地面上被踩
                this.slide(contact);
            }
            this.beTrampled = true;
        }

        if (other.tag == Tag.Ground) {
            if (!this.onGround) { //未落地
                this.contactGroundFrameCount = 0;
                this.velocity.y = -(this.bounceCoefficient * this.velocity.y);
            }
        }

        if (other.tag == Tag.Ant) {
            this.destroy();
            this.context && (this.context.score += this.scoreValue);
        }
    }

    private slide(contact: Contact) {
        //根据位置给予水平加速度
        if (contact.other >= 0.5) {
            this.acceleration.x = MConfigs.goldCoin.moveAccelerationX;
        } else {
            this.acceleration.x = - MConfigs.goldCoin.moveAccelerationX;
        }
    }

    onCollisionStay(other: DisplayCollider, contact: Contact) {
        if (this.onGround && other.tag == Tag.Leg) { //在地面上被踩
            this.slide(contact);
        }

        //判断落地
        if (other.tag == Tag.Ground && !this.onGround) {
            this.contactGroundFrameCount++;
            if (this.contactGroundFrameCount > 2) { //长时间接触地面
                //判断为落地
                this.onGround = true;
                if (this.beTrampled) { //被踩的过程中转换为落地状态
                    this.slide(contact);
                }
                this.velocity.y = 0;
                this.acceleration.y = 0;
            }

        }
    }

    onCollisionExit(other: DisplayCollider) {
        if (other.tag == Tag.Leg) {
            //停止滑动
            this.acceleration.x = 0;
            egret.Tween.get(this.velocity).to({ x: 0 }, MConfigs.goldCoin.moveSlowDownDuration);
            this.beTrampled = false;
        }
    }
}