import { Decorator } from "../Decorator/Decorator";
import DebugMgr from "../Mgr/DebugMgr";
import PhysicalSystem from "./PhysicalSystem";

@Decorator.OnUpdate
@Decorator.OnDestroy
export default class DisplayCollider extends egret.DisplayObjectContainer {
    public tag: Tag;
    /**是否开启调试模式 */
    private debug: boolean = true;
    /**本地坐标rect */
    public get localRect() {
        return this._localRect;
    }
    public set localRect(v: egret.Rectangle) {
        this._localRect = v;
    }
    private _localRect: egret.Rectangle = new egret.Rectangle(0, 0, 0, 0);

    /**世界坐标rect */
    public get rect() {
        let pos = this.localToGlobal(this.localRect.x, this.localRect.y);
        return new egret.Rectangle(
            pos.x,
            pos.y,
            this.localRect.width,
            this.localRect.height
        );
    }

    constructor(tag: Tag, localRect: egret.Rectangle) {
        super();
        this.tag = tag;
        this.localRect = localRect;
        PhysicalSystem.instance.addCollider(this);
    }

    /**@virtual */
    public onCollisionEnter(otherCollider: DisplayCollider, contact: Contact) {
    }

    /**@virtual */
    public onCollisionStay(otherCollider: DisplayCollider, contact: Contact) {

    }

    /**@virtual */
    public onCollisionExit(otherCollider: DisplayCollider) {

    }

    /**@override */
    onUpdate() {
        if (this.debug) {
            DebugMgr.instance.updateCollider(this.hashCode.toString(), this.rect, { color: 0x00ff00, lineSize: 1 });
        }
    }

    /**
     * @override
     */
    onDestroy() {
        PhysicalSystem.instance.removeCollider(this);
        DebugMgr.instance.clearCollider(this.hashCode.toString());
    }
}

export enum Tag {
    Ant,
    Leg,
    Ground,
    GoldCoin
}

export interface Contact { self: number, other: number }