import { MConst } from "../MConst";
import GameObject from "./GameObject";
import { ControllerDirection } from "./PlayerController";
import DisplayCollider, { Tag, Contact } from "./DisplayCollider";
import DebugMgr from "../Mgr/DebugMgr";
import GameMgr from "../Mgr/GameMgr";
import { MConfigs } from "../MConfigs";

export default class Ant extends GameObject {
    private speedValue: number = MConfigs.ant.speedValue;
    private contactToLeg: number = null;

    constructor() {
        super(Tag.Ant, MConst.AntLocalRect);
    }

    /**@override */
    protected onDraw() {
        this.addChild(new egret.Bitmap(RES.getRes("ant_png")));
    }

    public move(direction: ControllerDirection) {
        let dirVec: egret.Point = new egret.Point(0, 0); //默认为0
        switch (direction) {
            case ControllerDirection.Left:
                if (this.contactToLeg != 0) {
                    dirVec = new egret.Point(-1, 0);
                }
                break;
            case ControllerDirection.Right:
                if (this.contactToLeg != 1) {
                    dirVec = new egret.Point(1, 0);
                }
                break;

            case ControllerDirection.None:
                // dirVec = new egret.Point(0, 0);
                break;
            default:
                break;
        }
        dirVec.normalize(this.speedValue)
        this.velocity = dirVec;
    }

    public die() {
        this.visible = false;
    }

    onCollisionEnter(other: DisplayCollider, contact: Contact) {
        if (other.tag == Tag.Leg) {
            this.contactToLeg = contact.self;
        }
    }

    onCollisionStay(other: DisplayCollider, contact: Contact) {
        if (other.tag == Tag.Leg) {
            this.contactToLeg = contact.self;
        }
    }

    onCollisionExit(other: DisplayCollider) {
        if (other.tag == Tag.Leg) {
            this.contactToLeg = null;
        }
    }
}