import ComponentBase from "../components/ComponentBase";

function setPropertyDecorator(target: ComponentBase, name: string, callback: Function) {
    if (!target["decoratorCallback"]) {
        target["decoratorCallback"] = {};
    }
    target["decoratorCallback"]["LightRotate_" + name] = callback;
}

export namespace Decorator {
    /**
     * 
     * @param period 周期 单位：秒
     */
    export function LightRotate(period: number) {
        return function (target: ComponentBase, name: string) {
            setPropertyDecorator(target, name, (context: ComponentBase) => {
                let callback = () => {
                    egret.Tween.get(context[name]).to({ rotation: 360 }, period * 1000).call(callback);
                }
                callback();
            });
        }
    }

    export function DefaultCallback<T extends { new(...arg: any[]): {} }>(target: T) {
        return class extends target {
            constructor(...arg: any[]) {
                super();
                this["onUpdate"] = this["onUpdate"] || (() => { });
                this["onLoad"] = this["onLoad"] || (() => { });

                this["addEventListener"](egret.Event.ENTER_FRAME, this["onUpdate"], this);
                this["addEventListener"](egret.Event.ADDED_TO_STAGE, this["onLoad"], this);
                this["addEventListener"](egret.Event.REMOVED_FROM_STAGE, () => {
                    this["removeEventListener"](egret.Event.ENTER_FRAME, this["onUpdate"], this);
                    this["removeEventListener"](egret.Event.ADDED_TO_STAGE, this["onLoad"], this)
                    this["onDestroy"] && this["onDestroy"]();
                }, this);
            }
        }
    }

    export function OnLoad<T extends { new(...arg: any[]): {} }>(target: T) {
        return class extends target {
            constructor(...arg: any[]) {
                super(...arg);
                this["onLoad"] = this["onLoad"] || (() => { });
                this["addEventListener"](egret.Event.ADDED_TO_STAGE, this["onLoad"], this);
            }
        }
    }

    export function OnDestroy<T extends { new(...arg: any[]): {} }>(target: T) {
        return class extends target {
            constructor(...arg: any[]) {
                super(...arg);

                this["addEventListener"](egret.Event.REMOVED_FROM_STAGE, () => {
                    this["onDestroy"] && this["onDestroy"]();
                }, this);
            }
        }
    }

    export function OnUpdate<T extends { new(...arg: any[]): {} }>(target: T) {
        return class extends target {
            constructor(...arg: any[]) {
                super(...arg);
                this["onUpdate"] = this["onUpdate"] || (() => { });
                this["addEventListener"](egret.Event.ENTER_FRAME, this["onUpdate"], this);

                this["addEventListener"](egret.Event.REMOVED_FROM_STAGE, () => {
                    this["removeEventListener"](egret.Event.ENTER_FRAME, this["onUpdate"], this);
                }, this);
            }
        }
    }

    export function Skin(name: string) {
        return function <T extends { new(...arg: any[]): {} }>(target: T) {
            return class extends target {
                constructor(...arg: any[]) {
                    super(...arg);
                    let setSkin = () => {
                        this["skinName"] = `resource/skins/${name}.exml`;
                        if (this["skin"]) {
                            this["onSkinComplete"] && this["onSkinComplete"]();
                        } else {
                            this["addEventListener"](eui.UIEvent.COMPLETE, this["onSkinComplete"] || (() => { }), this);
                        }
                    }

                    if (this["preLoad"]) {
                        this["preLoad"]().then(setSkin);
                    } else {
                        setSkin();
                    }
                }
            }
        }
    }

}