"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("../utils");
/**
 * 单条收支记录
 */
var DogItem = (function (_super) {
    __extends(DogItem, _super);
    function DogItem(data) {
        var _this = _super.call(this) || this;
        _this.skinName = utils_1.getSkinPath('DogItem');
        _this.touchChildren = true;
        _this.init();
        return _this;
    }
    DogItem.prototype.init = function () {
        for (var i = 1; i <= 30; i++) {
            this["dog_lv_" + i].visible = false;
        }
        this.visible = false;
        this["loop"].play(0);
        this["loop"].items.forEach(function (item) {
            item.tween.loop = true;
        });
    };
    //设置等级
    DogItem.prototype.setLv = function (lv) {
        for (var i = 1; i <= 30; i++) {
            this["dog_lv_" + i].visible = false;
        }
        if (lv != 0) {
            this.visible = true;
            this["dog_lv_" + lv].visible = true;
            this.lvText.text = "lv." + lv;
        }
        else {
            this.visible = false;
        }
    };
    //设置单位产量
    DogItem.prototype.setRate = function (rate) {
        this.addGoldText.text = rate;
    };
    //加积分动画
    DogItem.prototype.addGold = function () {
        this["tips"].play(0);
    };
    //狗狗首次进入场景动画
    DogItem.prototype.firstAn = function () {
        this["first"].play(0);
    };
    return DogItem;
}(eui.Component));
exports.default = DogItem;
__reflect(DogItem.prototype, "\"c:/Users/duiba/Documents/kuwo/egret/src/mainScene/DogItem\".DogItem");
//# sourceMappingURL=DogItem.js.map