"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var MUtils;
(function (MUtils) {
    function setButtonImage(button, texture) {
        for (var _i = 0, _a = button.$children; _i < _a.length; _i++) {
            var i = _a[_i];
            if (i instanceof eui.Image) {
                i.source = texture;
                return;
            }
        }
        console.error("can not get image in the button");
    }
    MUtils.setButtonImage = setButtonImage;
    var imageCache = {};
    var loadImageCache = {};
    function loadImage(url) {
        var _this = this;
        if (!url) {
            console.error("empty url");
            return;
        }
        return new Promise(function (resolve) {
            if (imageCache[url]) {
                resolve(imageCache[url]);
                return;
            }
            if (loadImageCache[url]) {
                loadImageCache[url].once(egret.Event.COMPLETE, function (event) {
                    if (imageCache[url]) {
                        resolve(imageCache[url]);
                    }
                    else {
                        console.error("get image cache fail");
                    }
                }, _this);
            }
            else {
                var imgLoader = new egret.ImageLoader();
                imgLoader.once(egret.Event.COMPLETE, function (event) {
                    var loader = event.currentTarget;
                    var texture = new egret.Texture();
                    texture.bitmapData = loader.data;
                    imageCache[url] = texture;
                    resolve(texture);
                }, _this);
                imgLoader.load(url);
                loadImageCache[url] = imgLoader;
            }
        });
    }
    MUtils.loadImage = loadImage;
})(MUtils = exports.MUtils || (exports.MUtils = {}));
//# sourceMappingURL=MUtils.js.map