"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var GTime_1 = require("../util/GTime");
var ABNetManager = (function () {
    function ABNetManager() {
        /**
         * 调用接口对象池
         */
        this.callbackPool = {};
    }
    /**
     * 发送请求
     * @param net
     */
    ABNetManager.prototype.send = function (net) {
        var _this = this;
        var gTime = '?_=' + GTime_1.GTime.getTimestamp();
        var realUrl = net.uri;
        if (realUrl.indexOf('?') != -1) {
            gTime = '&_=' + GTime_1.GTime.getTimestamp();
        }
        //url加参数等特殊需求（例如再玩一次需要在dostart接口的url上加埋点）
        if (net.addUrl) {
            realUrl += net.addUrl;
        }
        window['$'].ajax({
            type: net.type,
            // url: realUrl + gTime,
            url: realUrl,
            dataType: net.dataType,
            data: net.param,
            async: true,
            success: function (result) {
                _this.onResponse(net, result);
            },
            error: function (message) {
                _this.onError(net, message);
            }
        });
    };
    /**
     * 接口底层错误
     */
    ABNetManager.ERROR = 'Error';
    return ABNetManager;
}());
exports.ABNetManager = ABNetManager;
__reflect(ABNetManager.prototype, "\"c:/Users/duiba/Documents/zhonghe_answer/egret/libs/tc/manager/ABNetManager\".ABNetManager");
//# sourceMappingURL=ABNetManager.js.map