import Scene from "../views/Scene";
import MyImage from "./MyImage";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { GTime } from "../../libs/tc/util/GTime";
import { TimeFormat } from "../../libs/tc/enum/TimeFormat";
import Panel from "../views/Panel";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import { Buried } from "../../libs/tw/util/Buried";
import ComponentBase from "../components/ComponentBase";
import GuidePanel from "../guidePanel/GuidePanel";
import { GCache } from "../../libs/tc/util/GCache";
import Loading from "../loading/Loading";
import { GetPrizeInfoData } from "../../libs/tw/data/plug/getPrizeInfo/GetPrizeInfoData";
import { ABNetManager } from "../../libs/tc/manager/ABNetManager";
import FriendItem from "./FriendItem";

export default class MainScene extends Scene {


	public get skinKey() { return 'MainScene' }
	public get groupName() { return 'main_scene' }

	private friendTest;
	constructor(data?) {
		super(data);
		if (data) {
		
		}
		this.percentHeight = 100;
		this.friendTest=new FriendItem()
		this.friendTest.x=300
		this.friendTest.y=300
		this.addChild(this.friendTest)
	}

	initEvents() {
		GDispatcher.addEvent(ABNetManager.ERROR, this.onError, this);
	}

	private onError(net: any, code: any): void {
		console.log(code);
		var msg: string;
		var msgArr: any = window['errorMessage'];
		if (!isNaN(code)) {
			msg = msgArr[code] ? msgArr[code] : '额哦，一个未知的错误';
		} else {
			msg = code;
		}

		PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, [msg], false);
	}
	removeEvents() {
		this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
		GDispatcher.removeEvent(ABNetManager.ERROR, this.onError, this);
	}

	protected onSkinComplete(): void {
		super.onSkinComplete();

	}

	start(data?) {

	}

	protected onLoad(): void {
		this.initUI();

		this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
	}

	private initUI(): void {
		//初始化数据
		this.initData();

	}
	private initData(): void {
	}


	private onEnterFrame(): void{

	}

}