import MScene from "../MViews/MScene";
import MButton from "../MUI/MButton";
import { Decorator } from "../Decorator/Decorator";
import MPanelCtrl from "../MCtrls/MPanelCtrl";
import InputNamePanel from "../Panel/InputNamePanel";
import Net from "../Global/Net";
import { MConfigs } from "../Global/MConfigs";
import RulePanel from "../Panel/RulePanel";
import MBuried from "../Global/MBuried";

@Decorator.ClassName("StartScene")
export default class StartScene extends MScene {
    public btnStart: MButton;
    public btnRule: eui.Button;
    public btnReward: eui.Button;
    public labelCompanyNum: eui.Label;

    onSkinComplete() {
        super.onSkinComplete();

        MBuried.doShowBuried(1);
        this.btnRule.onTap(this, () => {
            MBuried.doClickBuried(1);
            MPanelCtrl.instance.show(RulePanel);
        });
        MBuried.doShowBuried(3);
        this.btnStart.onTap(this, () => {
            MBuried.doClickBuried(3);
            MPanelCtrl.instance.show(InputNamePanel);
        });
        MBuried.doShowBuried(2);
        this.btnReward.onTap(this, () => {
            MBuried.doClickBuried(2);
            window.location.href = MConfigs.rewardUrl;
            // window.open(MConfigs.rewardUrl);
        });

        Net.sendGet(Net.Url.getCompanyNum, undefined, (res) => {
            this.labelCompanyNum.text = `已有${res.data.companyNo}家企业生成感恩账单`;
        });
    }
}
