import MScene from "../MViews/MScene";
import { Decorator } from "../Decorator/Decorator";
import MButton from "../MUI/MButton";
import GameMgr from "../Mgr/GameMgr";
import { MConfigs } from "../Global/MConfigs";
import MItem from "../MComponents/MItem";
import MPanelCtrl from "../MCtrls/MPanelCtrl";
import MPanel from "../MViews/MPanel";
import MSceneCtrl from "../MCtrls/MSceneCtrl";
import EndScene from "./EndScene";
import Net from "../Global/Net";
import WinningPanel from "../Panel/WinningPanel";
import { lottery } from "../Global/GUtils";
import { NetUtils } from "../Global/NetUtils";
import MBuried from "../Global/MBuried";
import MTimer from "../MComponents/MTimer";

@Decorator.ClassName("ShareScene")
export default class ShareScene extends MScene {
    public labelCompany: eui.Label;
    public labelNum: eui.Label;
    public imgAvatar: eui.Image;
    public dataGroup: eui.DataGroup;
    public btnShare: MButton;

    private order: number = null;
    private avatarType: 0 | 1 | 2 | 3 = null;
    private showTip: boolean = true;

    init(order: number, avatarType: 0 | 1 | 2 | 3) {
        this.order = order;
        this.avatarType = avatarType;
    }

    onSkinComplete() {
        super.onSkinComplete();

        this.labelCompany.text = GameMgr.instance.companyName;
        this.imgAvatar.source = `share_avatar_${this.avatarType}_png`;
        this.labelNum.text = `第${this.order}家生成感恩账单的企业`;

        let arr: {
            queMean: string,
            ansMean: string,
            sp: boolean
        }[] = [];
        let config = MConfigs.question;
        const answer = GameMgr.instance.answer;
        Object.keys(answer).forEach(e => {
            let queId = parseInt(e);
            let ansId = answer[queId];
            let sp: boolean = queId == 2 ? true : false;
            arr.push({
                queMean: config[queId].meaning,
                ansMean: config[queId].options[ansId].meaning,
                sp: sp
            });
        });
        this.dataGroup.dataProvider = new eui.ArrayCollection(arr);
        this.dataGroup.itemRenderer = Item;

        MTimer.set(120, () => {
            if (this.showTip) {
                MPanelCtrl.instance.show(class extends MPanel {
                    get skinKey() { return "TipPanel" }
                    public btnClose: MButton;
                    public btnOk: MButton;

                    onSkinComplete() {
                        super.onSkinComplete();

                        this.btnClose.onTap(this, () => this.hidePanel());
                        this.btnOk.onTap(this, () => this.hidePanel());
                    }
                });
            }
        });

        MBuried.doShowBuried(7);
        this.btnShare.onOnceTap(this, () => {
            this.showTip = false;
            MBuried.doClickBuried(7);

            Net.sendGet(Net.Url.getInviteCode, undefined, (res) => {
                let shareCode = res.data;

                //分享成功回调
                /* window["shareSuccess"] = function () {
                    
                }; */
                setTimeout(() => {
                    Net.sendPost(Net.Url.share, undefined, () => {
                        lottery();
                    }, true);
                }, 4000);
                //分享
                let url = this.getAppUrl(shareCode);
                window.location.href = url;
                // window["shareSuccess"]();
            }, true);

        });
    }

    private getShareUrl(shareCode: string): string {
        return MConfigs.share.url + "&shareCode=" + shareCode + "&projectId=" + NetUtils.getProjectId();
    }

    private getAppUrl(shareCode: string) {
        let appUrl = "http://fbclient/shareToThirdPlatform/";
        let param = MConfigs.share;
        appUrl += encodeURIComponent("lnk") + "/";
        appUrl += encodeURIComponent(param.title) + "/";
        appUrl += encodeURIComponent(param.desc) + "/";
        appUrl += encodeURIComponent(this.getShareUrl(shareCode)) + "/";
        appUrl += encodeURIComponent(param.imgUrl);
        return appUrl;
    }
}

const placeholder = "······························································";

class Item extends MItem {
    public label: eui.Label;
    data: {
        queMean: string,
        ansMean: string,
        sp: boolean
    }
    dataChanged() {
        let length = placeholder.length;
        length -= getLength(this.data.queMean);
        length -= getLength(this.data.ansMean);

        if (this.data.sp) {
            length++;
        }

        this.label.text = this.data.queMean + " " + placeholder.substr(0, length) + " " + this.data.ansMean;
    }
}

function getLength(str: string) {
    let count = 0;
    for (let i of str) {
        if (/[a-zA-Z]/.test(i)) {
            count += 2;
        } else {
            count += 3;
        }
    }
    return count;
}