import Scene from "../../views/Scene";
import MScene from "../MViews/MScene";
import { Decorator } from "../Decorator/Decorator";
import MButton from "../MUI/MButton";
import MItem from "../MComponents/MItem";
import { MConfigs } from "../Global/MConfigs";
import SceneCtrl from "../../ctrls/sceneCtrl";
import PanelCtrl from "../../ctrls/panelCtrl";
import CreateBillPanel from "../Panel/CreateBillPanel";
import MPanelCtrl from "../MCtrls/MPanelCtrl";
import GameMgr from "../Mgr/GameMgr";
import MBuried from "../Global/MBuried";


const carouselWidth = 400;
const carouselCount = 5;

type QuestionId = 0 | 1 | 2 | 3 | 4;
export type AnswerId = 0 | 1 | 2;
@Decorator.ClassName("MainScene")
@Decorator.OnUpdate
export default class MainScene extends MScene {
    public btnLast: MButton;
    public btnNext: MButton;
    public imgQuestion: eui.Image;
    public dataGroup: eui.DataGroup;

    private toggleGroup: eui.RadioButtonGroup = new eui.RadioButtonGroup();
    private answer: { [id: number]: AnswerId } = {};

    private _currentAnswer: AnswerId = null;
    public get currentAnswer(): AnswerId {
        return this._currentAnswer;
    }
    public set currentAnswer(v: AnswerId) {
        if (v != this._currentAnswer) {
            this.btnNext.enabled = v != null;
            this._currentAnswer = v;
        }
    }


    private _currentQuestionId: QuestionId = 0;
    private set currentQuestionId(v: QuestionId) {
        v = Math.clamp(v, 0, 4) as QuestionId;
        if (v != this._currentQuestionId) {
            this.refreshPage(v);
            this._currentQuestionId = v;
        }
    }
    private get currentQuestionId(): QuestionId {
        return this._currentQuestionId;
    }


    onSkinComplete() {
        super.onSkinComplete();

        this.dataGroup.itemRenderer = AnswerItem;
        this.toggleGroup.addEventListener(eui.UIEvent.CHANGE, (event: eui.UIEvent) => {
        }, this);

        this.refreshPage(this.currentQuestionId);
        this.btnNext.enabled = false;
        this.btnLast.onTap(this, () => {
            this.currentQuestionId--;
        });
        this.btnNext.onTap(this, () => {
            this.answer[this.currentQuestionId] = this.currentAnswer;
            console.log(this.answer);
            if (this.currentQuestionId >= 4) {
                MBuried.doClickBuried(4);
                const arr: number[] = [];
                for (let key of Object.keys(this.answer)) {
                    arr.push(this.answer[key] + 1);
                }
                GameMgr.instance.answer = this.answer;
                MPanelCtrl.instance.show<CreateBillPanel>(CreateBillPanel).init(GameMgr.instance.companyName, arr.join(","));
            } else {
                this.currentQuestionId++;
            }
        });

        //创建轮播
        for (let i = 0; i <= carouselCount - 1; i++) {
            let label = new eui.Label();
            label.size = 20;
            label.y = 13;
            this.addChild(label);
            label.x = 760 + i * carouselWidth;
            this.carouselList.push(label);
            this.setCarousel(label);
        }

    }

    private carouselIndex = 0;
    private setCarousel(label: eui.Label) {
        label.text = MConfigs.carousel[this.carouselIndex++];
        if (this.carouselIndex > MConfigs.carousel.length - 1) {
            this.carouselIndex = 0;
        }
    }

    private refreshPage(id: QuestionId) {
        if (id == 4) { //曝光生成账单按钮
            MBuried.doShowBuried(4);
        }

        this.currentAnswer = this.answer[id];
        //题目
        this.imgQuestion.source = `main_question_${id}_png`;

        //答案
        const config = MConfigs.question[id];
        let arr: AnswerItemData[] = [];
        for (let i = 0; i < config.options.length; i++) {
            arr.push({
                id: i as AnswerId,
                text: config.options[i].text,
                toggleGroup: this.toggleGroup,
                context: this,
                selected: i == this.currentAnswer
            })
        }
        this.dataGroup.dataProvider = new eui.ArrayCollection(arr);

        //上一页按钮
        if (config.btn.last.enabled) {
            this.btnLast.visible = true;
            this.btnLast.normalImage = "main_btn_last_png";
            this.btnLast.x = config.btn.last.posX;
        } else {
            this.btnLast.visible = false;
        }

        //下一页按钮
        this.btnNext.x = config.btn.next.posX;
        this.btnNext.normalImage = `main_btn_next_${config.btn.next.btnId}_png`;
        this.btnNext.disabledImage = `main_btn_next_${config.btn.next.btnId}_disabled_png`;
    }

    private carouselList: eui.Label[] = [];
    onUpdate() {
        for (let i = 0; i <= this.carouselList.length - 1; i++) {
            let label = this.carouselList[i];
            if (label.x < -carouselWidth * carouselCount / 2 + 750 / 2) {
                label.x = carouselCount * carouselWidth / 2 + 750 / 2;
                this.setCarousel(label);
            } else {
                label.x -= 3;
            }

        }
    }
}

interface AnswerItemData {
    id: AnswerId,
    text: string,
    toggleGroup: eui.RadioButtonGroup,
    context: MainScene,
    selected: boolean
}

class AnswerItem extends MItem {
    public toggle: eui.RadioButton;
    public label: eui.Label;
    data: AnswerItemData

    onSkinComplete() {
        this.toggle.onTap(this, () => {
            this.data.context.currentAnswer = this.data.id;
        });
    }

    dataChanged() {
        this.toggle.group = this.data.toggleGroup;
        this.label.text = this.data.text;
        this.toggle.selected = this.data.selected;
    }
}