import MPanel from "../MViews/MPanel";
import MButton from "../MUI/MButton";
import { Decorator } from "../Decorator/Decorator";
import MBuried from "../Global/MBuried";
import { MUtils } from "../Global/MUtils";

@Decorator.ClassName("WinningPanel")
export default class WinningPanel extends MPanel {
    // @Decorator.LightRotate(7000)
    public light: eui.Image;
    public btnClose: MButton;
    public imgPrize: eui.Image;
    public btnReceive: MButton;

    private url: string = null;
    private imgUrl: string = null;

    init(url: string, imgUrl: string) {
        this.url = url;
        this.imgUrl = imgUrl;
    }

    onSkinComplete() {
        super.onSkinComplete();

        /* MUtils.loadImage(this.imgUrl).then((tex) => {
            this.imgPrize.width = (220 / tex.textureHeight) * tex.textureHeight;
            this.imgPrize.source = tex;
        }); */

        this.imgPrize.source = this.imgUrl;
        this.btnClose.onTap(this, () => this.hidePanel());
        MBuried.doShowBuried(11);
        this.btnReceive.onTap(this, () => {
            MBuried.doClickBuried(11);
            this.hidePanel()
            window.location.href = this.url;
            // window.open(this.url);
        });
    }
}