import MPanel from "../MViews/MPanel";
import { HtmlTextParser } from "../../../libs/tc/util/HtmlTextParser";
import MButton from "../MUI/MButton";
import Net from "../Global/Net";
import { MConfigs } from "../Global/MConfigs";

export default class RulePanel extends MPanel {
    get skinKey() { return "RulePanel" }
    public text: eui.Label;
    public btnClose: MButton;
    data: {
        msg: string
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.text.textFlow = new HtmlTextParser().parse(MConfigs.rule || testRule);
        this.btnClose.onTap(this, () => this.hidePanel());
    }
}

const testRule = `结构一节将帮助你了解常见库的格式以及如何为每种格式书写正确的声明文件。 如果你在编辑一个已经存在的文件，那么你可能不需要阅读此章节。 如果你在书写新的声明文件，那么你必须阅读此章节以理解库的不同格式是如何影响声明文件的书写的。
结构一节将帮助你了解常见库的格式以及如何为每种格式书写正确的声明文件。 如果你在编辑一个已经存在的文件，那么你可能不需要阅读此章节。 如果你在书写新的声明文件，那么你必须阅读此章节以理解库的不同格式是如何影响声明文件的书写的。`;