import { Decorator } from "../Decorator/Decorator";
import MButton from "../MUI/MButton";
import MPanel from "../MViews/MPanel";
import GameMgr from "../Mgr/GameMgr";
import SceneCtrl from "../../ctrls/sceneCtrl";
import MSceneCtrl from "../MCtrls/MSceneCtrl";
import MainScene from "../Scene/MainScene";
import ToastPanel from "../MComponents/MToastPanel";

@Decorator.ClassName("InputNamePanel")
export default class InputNamePanel extends MPanel {
    public btnClose: MButton;
    public editor: eui.EditableText;
    public btn: MButton;

    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => this.hidePanel());
        this.btn.onOnceTap(this, (resume) => {
            const text = this.editor.text;
            if (text == "") {
                ToastPanel.show("请输入企业名称");
                resume();
                return;
            }
            GameMgr.instance.companyName = text;
            MSceneCtrl.instance.change(MainScene);
            this.hidePanel();
        });
    }
}