import MPanel from "../MViews/MPanel";
import { Decorator } from "../Decorator/Decorator";
import MButton from "../MUI/MButton";
import { ThroughSubmitData } from "../../../libs/tw/data/custom/throughSubmit/ThroughSubmitData";
import GameMgr from "../Mgr/GameMgr";
import Net from "../Global/Net";
import MSceneCtrl from "../MCtrls/MSceneCtrl";
import ShareScene from "../Scene/ShareScene";
import MBuried from "../Global/MBuried";

@Decorator.ClassName("CreateBillPanel")
export default class CreateBillPanel extends MPanel {
    public btnClose: MButton;
    public btnAlter: MButton;
    public btnCreate: MButton;
    public labelCompany: eui.Label;
    private companyName: string = null;
    private answer: string = "";

    init(companyName: string, answer: string) {
        this.companyName = companyName;
        this.answer = answer;
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => this.hidePanel());
        MBuried.doShowBuried(5);
        this.btnAlter.onTap(this, () => {
            MBuried.doClickBuried(5);
            this.hidePanel();
        });
        this.labelCompany.text = this.companyName;

        MBuried.doShowBuried(6);
        this.btnCreate.onOnceTap(this, () => {
            MBuried.doClickBuried(6);
            Net.sendPost(Net.Url.answer, {
                companyName: this.companyName,
                answers: this.answer
            }, (res) => {
                MSceneCtrl.instance.change<ShareScene>(ShareScene).init(res.data.companyNo, res.data.avatarType);
                this.hidePanel();
            });
        });
    }
}