import { NetManager } from "../../../libs/tw/manager/NetManager";
import ToastPanel from "../MComponents/MToastPanel";
import Loading from "../../loading/Loading";
import MSceneCtrl from "../MCtrls/MSceneCtrl";
import StartScene from "../Scene/StartScene";
import MPanelCtrl from "../MCtrls/MPanelCtrl";
import { NetUtils } from "./NetUtils";
import { start } from "./GUtils";

const projectId = NetUtils.getProjectId();
export default class Net {
    public static cache: object = {};

    /**
     * 
     * @param uri URL
     * @param param 参数
     * @param onSuccess 返回成功时的回调
     * @param onFail 返回失败是的回调 | 是否使用默认失败回调函数
     * @param pollingCheck 每次轮询回调
     * @param pollingCount 轮询最大次数
     */
    public static sendGet(uri: string, param: any, onSuccess: (res: any) => void, onFail?: ((res: any) => any) | boolean, pollingCheck?: (res: any) => boolean, pollingCount?: number) {
        this.mSend("get", uri, param, onSuccess, onFail, pollingCheck, pollingCount);
    }

    /**
     * 
     * @param uri URL
     * @param param 参数
     * @param onSuccess 返回成功时的回调
     * @param onFail 返回失败是的回调 | 是否使用默认失败回调函数
     * @param pollingCheck 每次轮询回调
     * @param pollingCount 轮询最大次数
     */
    public static sendPost(uri: string, param: any, onSuccess: (res: any) => void, onFail?: ((res: any) => any) | boolean, pollingCheck?: (res: any) => boolean, pollingCount?: number) {
        this.mSend("post", uri, param, onSuccess, onFail, pollingCheck, pollingCount);
    }

    private static mSend(type: string, uri: string, param: any, onSuccess: (res: any) => void, onFail?: ((res: any) => any) | boolean, pollingCheck?: (res: any) => boolean, pollingCount?: number) {
        if (pollingCheck) {
            Loading.instace.show();
        }

        NetManager.ins.send({
            name: uri,
            uri: uri,
            type: type,
            dataType: 'json',
            param: param,
            callback: (success: any, res: any) => {
                Net.cache[uri] = res;

                if (pollingCheck) {
                    Loading.instace.hide();
                }

                if (success) {
                    console.log("response", uri, res);
                    onSuccess(res);
                } else {
                    console.warn("response", uri, res);

                    let errorMsg =
                        res && (
                            (
                                res["desc"] || res["message"]
                            )
                            || (
                                (
                                    res["code"] && "network error:" + res["code"]
                                )
                                || "network error"
                            )
                        )
                        || "network error";

                    if (typeof onFail == "function") {
                        if (!onFail(res)) { //若客户没有处理错误码，怎么默认显示错误消息或描述文字的弹窗
                            ToastPanel.show(errorMsg);
                        }
                    } else {
                        if (typeof onFail == "boolean" && onFail == true) {
                            Net.defaultOnFail && Net.defaultOnFail(res);
                        }
                        ToastPanel.show(errorMsg);
                    }
                }
            },
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        });
        console.log("requset", uri, param);
    }

    public static defaultOnFail: (res: any) => void = () => {
        // MSceneCtrl.instance.change(StartScene);
        start();
        MPanelCtrl.instance.closeAll();
        Loading.instace.hide();
    }

    public static urlReplace() {
        for (let i of Object.keys(Net.Url)) {
            for (let j of Object.keys(Net.urlReplaceConfig)) {
                Net.Url[i] = Net.Url[i].replace(new RegExp(j, "g"), Net.urlReplaceConfig[j]);
            }
        }
    }

    private static urlReplaceConfig = {
        "{projectId}": projectId
    }

    public static readonly Url = {
        queryPrize: "/projectx/{projectId}/prize.query",
        getJoinCount: "/projectx/{projectId}/join_3/queryMyJoin.do",
        answer: "/projectx/{projectId}/join_1/join.do",
        share: "/projectx/{projectId}/join_2/join.do",
        lottery: "/projectx/{projectId}/join_3/join.do",
        //生成邀请码
        getInviteCode: "/projectx/{projectId}/join_4/genInvite.do",
        //分享者答题信息
        queryAnswer: "/projectx/{projectId}/coop/answerInfo.do",
        getUserSp: "/projectx/{projectId}/getUserSpList.query",
        getCompanyNum: "/projectx/{projectId}/join_1/companyInfo.do"
    }
}