import { MUtils } from "./MUtils";
import { MConst } from "./MConst";
import { MConfigs } from "./MConfigs";
import MSceneCtrl from "../MCtrls/MSceneCtrl";
import StartScene from "../Scene/StartScene";
import MPanelCtrl from "../MCtrls/MPanelCtrl";
import Loading from "../../loading/Loading";
import Net from "./Net";
import ToastPanel from "../MComponents/MToastPanel";
import MPanel from "../MViews/MPanel";
import MButton from "../MUI/MButton";
import WinningPanel from "../Panel/WinningPanel";
import EndScene from "../Scene/EndScene";
import MBuried from "./MBuried";

export const getResPath = () => window['resPath'] || '';
export const getSkinPath = (key: any) => `resource/skins/${key}Skin.exml`

let shareImg: HTMLElement = null;
export function setShareImg(imgUrl: string, rect: egret.Rectangle, visible: boolean = true) {
    shareImg = shareImg || document.getElementById('shareImg');
    shareImg.style.position = 'absolute';
    shareImg.style.display = 'block';
    shareImg.style.visibility = "visible";
    shareImg.style.opacity = visible ? "1" : "0";
    let scaler = document.body.clientWidth / 750;
    shareImg.style.width = (scaler * rect.width).toString() + "px";
    shareImg.style.height = (scaler * rect.height).toString() + "px";
    shareImg.style.left = (rect.x * scaler).toString() + "px";
    shareImg.style.top = (rect.y * scaler).toString() + "px";
    shareImg['src'] = imgUrl;
}
export function clearShareImg() {
    if (!shareImg) {
        console.log("shareImg is null");
        return;
    }

    shareImg.style.width = "0px";
    shareImg.style.height = "0px";
    shareImg.style.visibility = "hidden";
}

export function start() {
    let lotteryCount = 0, joinCount = 0;
    Net.sendGet(Net.Url.getUserSp, undefined, (res) => {
        if (res.data["sp_2"]) {
            lotteryCount = res.data["sp_2"];
        }

        Net.sendGet(Net.Url.getJoinCount, undefined, (res) => {
            joinCount = res.data.total;
            if (lotteryCount == 0 && joinCount > 0) {
                answered();
            } else if (lotteryCount > 0 && joinCount == 0) {
                prizeLack();
            } else if (lotteryCount == 0 && joinCount == 0) {

                startAnswer();
            } else {
                ToastPanel.show("logic error");
                Loading.instace.show();
            }
        });
    });
}

function startAnswer() {
    MSceneCtrl.instance.change(StartScene);
}

function prizeLack() {
    lottery();
}

function answered() {
    MSceneCtrl.instance.change(EndScene);
}

export function lottery() {
    Net.sendPost(Net.Url.lottery, undefined, (res1) => {
        Net.sendGet(Net.Url.queryPrize, {
            ids: [res1.data.prizeId]
        }, (res2) => {
            let icon = "";
            for (let i of res2.data) {
                if (i.id == res1.data.prizeId) {
                    icon = i.icon;
                }
            }
            MPanelCtrl.instance.show<WinningPanel>(WinningPanel).init(res1.data.url, icon);
        });
    }, (res) => {
        if (res.code == "1") {
            MPanelCtrl.instance.show(class extends MPanel {
                get skinKey() { return "LackPanel" }
                public btnClose: MButton;
                public btnOk: MButton;
                onSkinComplete() {
                    super.onSkinComplete();
                    this.btnClose.onTap(this, () => this.hidePanel());
                    MBuried.doShowBuried(12);
                    this.btnOk.onTap(this, () => {
                        this.hidePanel();
                        MBuried.doClickBuried(12);
                    });
                }
            });
            return true;
        } else {
            Net.defaultOnFail(res);
        }
    });
    MSceneCtrl.instance.change(EndScene);
}