import GameComponent from "./GameComponent";
import GameObject from "./GameObject";
import PhycicsSystem from "./PhycicsSystem";
import Physics from "./Physics";

/**碰撞器 */
export default abstract class Collider extends GameComponent {
    public physics: Physics = null;
    public group: ColliderGroup = ColliderGroup.None;
    public type: ColliderType = null;
    setData(...ags: any[]): void {
        this.physics && this.physics.onColliderResize(this);
    }

    onEnabled() {
        PhycicsSystem.instance.addCollider(this);
        //自动设置物理组件
        let physics = this.owner.getComponent<Physics>(Physics);
        if (physics) {
            this.physics = physics;
            physics.collider = this;
        }
    }

    onDisabled() {
        PhycicsSystem.instance.removeCollider(this);
    }

    /**获取碰撞器的中心的节点坐标 */
    abstract getCenter(): egret.Point;
}

export class CircleCollider extends Collider {
    public radius: number = 0
    public center: egret.Point = new egret.Point();
    constructor(owner: GameObject) {
        super(owner);
        this.type = ColliderType.Circle;
    }

    setData(x: number, y: number, radius: number) {
        this.radius = radius;
        this.center.x = x;
        this.center.y = y;
        super.setData();
    }

    getCenter() {
        return this.center;
    }
}

export class RectCollider extends Collider {
    public rect: egret.Rectangle = new egret.Rectangle();

    constructor(owner: GameObject) {
        super(owner);
        this.type = ColliderType.Rect;
    }

    setData(x: number, y: number, width: number, height: number) {
        this.rect.x = x;
        this.rect.y = y;
        this.rect.width = width;
        this.rect.height = height;
        super.setData();
    }

    getCenter() {
        return new egret.Point(this.rect.x + this.rect.width / 2, this.rect.y + this.rect.height / 2);
    }
}

/**碰撞组 */
export enum ColliderGroup {
    None,
    Ball,
    Bullet,
    Wall,
    Ground,
    Drop,
    Car
}

/**碰撞器形状类型 */
export enum ColliderType {
    Circle,
    Rect
}