import AssetAdapter from "./AssetAdapter";
import MPanelCtrl from "./MainSrc/MCtrls/MPanelCtrl";
import MSceneCtrl from "./MainSrc/MCtrls/MSceneCtrl";
import Loading from "./loading/Loading";
import ThemeAdapter from "./ThemeAdapter";
import layers from "./MainSrc/MViews/MLayers";
import MTopLayerCtrl from './MainSrc/MCtrls/MTopLayerCtrl';
import { getResPath, start } from "./MainSrc/Global/GUtils";
import { customClassPrototype } from "./MainSrc/MComponents/Custom";
import { Decorator } from "./MainSrc/Decorator/Decorator";
import ToastPanel from "./MainSrc/MComponents/MToastPanel";
import MProgressBar from "./MainSrc/MUI/MProgressBar";
import MButton from "./MainSrc/MUI/MButton";
import Net from "./MainSrc/Global/Net";
import StartScene from "./MainSrc/Scene/StartScene";
import MTimer from "./MainSrc/MComponents/MTimer";
import MTweenMgr from "./MainSrc/MComponents/MTween";
import PhycicsSystem from "./MainSrc/Game/PhycicsSystem";
import { NetUtils } from "./MainSrc/Global/NetUtils";
import MLabel from "./MainSrc/MUI/MLabel";
import { MConfigs } from "./MainSrc/Global/MConfigs";
import MainScene from "./MainSrc/Scene/MainScene";
import SceneCtrl from "./ctrls/sceneCtrl";
import MBuried from "./MainSrc/Global/MBuried";

@Decorator.OnUpdate
class Main extends eui.UILayer {
    constructor() {
        super();
        customClassPrototype();

        if (window["FBBankAPP"] && window["FBBankAPP"][" ShowBackAndForwardBar"]) {
            // var Route = window["FBBankAPP"].ShowBackAndForwardBar();
        }
    }

    protected createChildren() {
        super.createChildren();

        this.init();
        //注入自定义的素材解析器
        let assetAdapter = new AssetAdapter();
        egret.registerImplementation("eui.IAssetAdapter", assetAdapter);
        egret.registerImplementation("eui.IThemeAdapter", new ThemeAdapter());
        egret.ImageLoader.crossOrigin = "anonymous";
        //设置屏幕适配方式
        this.stage.scaleMode = egret.StageScaleMode.FIXED_WIDTH;
        this.runGame().catch(e => {
            console.log(e);
        });
    }

    private init() {
        MTimer.init();
        MTweenMgr.instance.init();
        // PhycicsSystem.init();
        //替换URL
        Net.urlReplace();
        //从皮肤的mconfig对象上更新MConfig
        MConfigs.updateConfig();
        MBuried.init(MConfigs.appId, NetUtils.getProjectId());

        layers.init(this);
        Loading.init(layers.topLayer);
        MPanelCtrl.instance.init(layers.popupLayer);
        MSceneCtrl.instance.init(layers.sceneLayer);
        MTopLayerCtrl.instance.init(layers.topLayer);
        ToastPanel.parent = layers.toastLayer;
    }

    private async runGame() {
        await this.loadResource()
        this.createGameScene();
    }

    private async loadResource() {
        try {
            await RES.loadConfig("default.res.json", getResPath() + "resource/");
            await this.loadTheme();
        }
        catch (e) {
            console.error(e);
        }
    }

    private loadTheme() {
        return new Promise((resolve, reject) => {
            // load skin theme configuration file, you can manually modify the file. And replace the default skin.
            //加载皮肤主题配置文件,可以手动修改这个文件。替换默认皮肤。
            let theme = new eui.Theme("resource/default.thm.json", this.stage);
            theme.addEventListener(eui.UIEvent.COMPLETE, () => {
                resolve();
            }, this);

        })
    }

    /**
     * 创建场景界面
     * Create scene interface
     */
    protected async createGameScene() {
        start();
    }
}

window["Main"] = Main;
window["MProgressBar"] = MProgressBar;
window["MButton"] = MButton;
window["MLabel"] = MLabel;