"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var DataManager_1 = require("../manager/DataManager");
var TwFun = (function () {
    function TwFun() {
    }
    /**
     * 获取兑换记录地址
     * @param actId 活动ID
     * @param type 入库活动(游戏、新活动工具、自定义活动工具、竞猜、答题)   —   00
     *             插件活动、插件式抽奖工具   —  01
     *             开心码   —   02
     *             集卡开奖 — 03
     */
    TwFun.getRecordUrl = function (type, ids) {
        var recordUrl;
        var oaId;
        if (DataManager_1.DataManager.ins.customCfgData) {
            oaId = DataManager_1.DataManager.ins.customCfgData.oaId;
            recordUrl = DataManager_1.DataManager.ins.customCfgData.recordUrl;
        }
        else {
            oaId = DataManager_1.DataManager.ins.gameCfgData.gameInfo.oaId;
            recordUrl = window['recordUrl'];
        }
        if (!ids) {
            ids = [oaId];
        }
        var i = 0;
        var len = ids.length;
        for (i; i < len; i++) {
            recordUrl += '?origins=' + ids[i] + type;
        }
        return recordUrl;
    };
    /**
     * 生成活动链接
     * @param type 1游戏、2活动工具
     * @param activityId 活动ID
     * @param dpm 点击埋点
     * @param dcm 曝光埋点
     */
    TwFun.createActivityUrl = function (type, activityId, dpm, dcm) {
        var url;
        switch (type) {
            case 1:
                url = '//activity.m.duiba.com.cn/ngame/duiba?id=';
                break;
            case 2:
                url = '//activity.m.duiba.com.cn/newActivity/duiba?id=';
                break;
        }
        return url + activityId + '&dbnewopen&dpm=' + dpm + '&dcm=' + dcm;
    };
    /**
     * 获取指定app指定索引的的活动ID
     * @param appId appId
     * @param pool 活动池
     * pool格式
     * {
     *      appId1: [activityId1, activityId2, activityId3, activityId4],
     *      appId2: [activityId1, activityId2, activityId3, activityId4]
     * }
     * 默认必须有内测的appId和对应的活动ID组
     * 当查找不到指定的appId则获取默认的内测数据
     * @param index 活动索引
     */
    TwFun.getActivityIdByAppId = function (appId, pool, index) {
        return pool[appId] ? pool[appId][index] : pool[1][index];
    };
    return TwFun;
}());
exports.TwFun = TwFun;
__reflect(TwFun.prototype, "\"c:/Users/duiba/Documents/kuwo/egret/libs/tw/util/TwFun\".TwFun");
//# sourceMappingURL=TwFun.js.map