"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var TimeFormat_1 = require("../enum/TimeFormat");
var GTime = (function () {
    function GTime() {
    }
    /**
     * 获取当前时间戳
     * @returns {number}
     */
    GTime.getTimestamp = function () {
        return new Date().getTime();
    };
    /**
     * 传入秒数返回带格式的时间
     * @param time 单位秒
     * @param type 枚举类型CountDownType
     * @param dibit 是否双位
     */
    GTime.formatTime = function (time, type, dibit, suffixs) {
        if (type === void 0) { type = TimeFormat_1.TimeFormat.HMS; }
        if (dibit === void 0) { dibit = false; }
        if (suffixs === void 0) { suffixs = ['d', 'h', 'm', 's']; }
        var countdown = this.getCountDown(time, type, dibit);
        countdown = countdown.map(function (val, index) { return "" + (val < 10 ? '0' + val : val) + suffixs[index]; });
        return countdown.join('');
    };
    /**
     * 倒计时
     * @param time 单位秒
     * @param type 枚举类型CountDownType
     * @param dibit 是否双位
     */
    GTime.getCountDown = function (time, type, dibit) {
        if (type === void 0) { type = TimeFormat_1.TimeFormat.HMS; }
        if (dibit === void 0) { dibit = false; }
        var result = [];
        if (type.indexOf('s') !== -1) {
            result.push(time % 60);
        }
        if (type.indexOf('m') !== -1) {
            result.unshift(Math.floor((time % 3600) / 60));
        }
        if (type.indexOf('h') >= 0) {
            if (type == TimeFormat_1.TimeFormat.HMS) {
                result.unshift(Math.floor(time / 3600));
            }
            else {
                result.unshift(Math.floor((time % 86400) / 3600));
            }
        }
        if (type.indexOf('d') >= 0) {
            result.unshift(Math.floor(time / 86400));
        }
        if (dibit)
            result = result.map(function (ele) {
                return ele < 10 ? "0" + ele : ele;
            });
        return result;
    };
    return GTime;
}());
exports.GTime = GTime;
__reflect(GTime.prototype, "\"c:/Users/duiba/Documents/kuwo/egret/libs/tc/util/GTime\".GTime");
//# sourceMappingURL=GTime.js.map