"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 对象池
 */
var GPool = (function () {
    function GPool() {
    }
    /**
     * 根据类型设置缓存最大个数
     * @param className
     * @param count
     */
    GPool.setMaxCountByType = function (className, count) {
        this.maxCount[className] = count;
    };
    /**
     * 取出
     * @param className 资源名
     * @param 类名
     */
    GPool.takeOut = function (className, classObj, isCreate) {
        if (!className || className == '') {
            return;
        }
        var obj;
        if (this.pool[className] && this.pool[className].length) {
            obj = this.pool[className].shift();
        }
        else if (isCreate) {
            if (!classObj) {
                classObj = eval(className);
            }
            obj = new classObj();
        }
        return obj;
    };
    /**
     * 回收
     * @param className 资源Class
     * @param obj 资源
     */
    GPool.recover = function (className, obj) {
        if (!obj || !className) {
            return;
        }
        if (!this.pool[className]) {
            this.pool[className] = [];
        }
        if (!this.maxCount[className]) {
            this.maxCount[className] = 100;
        }
        if (this.pool[className].length > this.maxCount[className]) {
            return;
        }
        this.pool[className].push(obj);
        if (obj['dispose']) {
            obj.dispose();
        }
    };
    GPool.pool = {};
    GPool.maxCount = {};
    return GPool;
}());
exports.GPool = GPool;
__reflect(GPool.prototype, "\"c:/Users/duiba/Documents/kuwo/egret/libs/tc/util/GPool\".GPool");
//# sourceMappingURL=GPool.js.map