import Panel from "../views/Panel";
import { MConfigs } from "../MConfigs";
import AchievementPicItem from "../item/AchievementPicItem";

export default class ViewAchievementPanel extends Panel {
    public get skinKey() { return "ViewAchievementPanel" }
    public get groupName() { return "view_achievement_panel" }

    public date: eui.Label;
    public achievementName: eui.Label;
    public picContainer: eui.DataGroup;

    protected preLoadRes() {
        return new Promise(async (resolve, reject) => {
            await RES.loadGroup(this.groupName);
            resolve();
        });
    }

    private achievementPicItem: AchievementPicItem = null;

    protected onSkinComplete() {
        super.onSkinComplete();
        console.log(this.data.configData)
        console.log(this.data.configData["id"])
      //  let configData = this.data["id"];
        this.achievementName.text = this.data["name"];
        this.picContainer.addChild(new AchievementPicItem(this.data.index));
    }
}