import Panel from "../views/Panel";
import { NetBuried } from "../NetBuried";
import { NetPromise } from "../NetPromise";
import TopLayerCtrl from "../ctrls/topLayerCtrl";
import { ModuleTypes } from "../types/sceneTypes";

export default class LearnedMusicPanel extends Panel {
    public get skinKey() { return "LearnedMusicPanel" }
    public btnOk: eui.Button;
    public musicName: eui.Label;
    public singerName: eui.Label;
    public iconArea: eui.Image;

    onSkinComplete() {
        super.onSkinComplete();
        NetBuried.ins.showLog(28)
        this.btnOk.addEventListener(egret.TouchEvent.TOUCH_TAP, this.opTap_btnOk, this);
        this.musicName.text = this.data["musicName"];
        this.singerName.text = this.data["singerName"];
        this.iconArea.source = this.data["pic"];
    }

    initEvents(){
        super.initEvents()
        this.iconArea.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_iconArea,this)
    }

    removeEvents(){
        super.removeEvents()
        this.iconArea.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_iconArea,this)
    }

    opTap_btnOk(){
        this.hidePanel()
        NetPromise.ins.likeSong(window["loginUid"],window["sid"],this.data["musicrid"])
        .then(()=>{
           
        })
        .catch(()=>{
           // this.enabled=true;
        })
    }

    showToast(val) {
        //console.log(val)
        TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, { msg: val });
    }

    onTap_iconArea(){
        console.log(this.data.data)
        let _data=this.data.data.song;
        NetPromise.ins.handlePlay({
            album: _data.album,
            artist: _data.artist,
            formats: _data.formats,
            fsongname: "",
            hasmv: false,
            isdownload: 0,
            kmark: "",
            musicrid: _data.musicrid,
            name: _data.name,
            nationid: _data.nationid,
            online: _data.online,
            pay:  _data.pay,
            psrc: "h5app_worldcup"
        })
    }

    /**
     * @param data
     */
    constructor(data: any) {
        super(data);
    }


    hidePanel(){
        NetBuried.ins.clickLog(28)
        super.hidePanel()
        this.data.callback()
    }
}