import Panel from "../views/Panel";
import { NetBuried } from "../NetBuried";

export default class LearnedMusicPanel extends Panel {
    public get skinKey() { return "LearnedMusicPanel" }
    public btnOk: eui.Button;
    public musicName: eui.Label;
    public singerName: eui.Label;
    public iconArea: eui.Image;

    onSkinComplete() {
        super.onSkinComplete();
        NetBuried.ins.showLog(28)
        this.btnOk.addEventListener(egret.TouchEvent.TOUCH_TAP, this.hidePanel, this);
        this.musicName.text = this.data["musicName"];
        this.singerName.text = this.data["singerName"];
        this.iconArea.source = this.data["pic"];
        
    }

    initEvents(){
        super.initEvents()
        this.iconArea.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_iconArea,this)
    }

    removeEvents(){
        super.removeEvents()
        this.iconArea.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_iconArea,this)
    }

    onTap_iconArea(){
        
    }

    /**
     * @param data
     */
    constructor(data: any) {
        super(data);
    }


    hidePanel(){
        NetBuried.ins.clickLog(28)
        super.hidePanel()
        this.data.callback()
    }
}