import Panel from "../views/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetBuried } from "../NetBuried";

export default class GetTicketPanel extends Panel {
    public get skinKey() { return "GetTicketPanel" }
    public btnOk: eui.Button;
    public ticketName: eui.Label;
    public ticketArea: eui.Image;

    constructor(data: any) {
        super(data);
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.ticketName.text = DataManager.ins.getPlugOrderStatusData.lottery.title;
        this.ticketArea.source = DataManager.ins.getPlugOrderStatusData.lottery.img;
        this.ticketArea.width=640*0,8;
        this.ticketArea.height=280*0.8;
        NetBuried.ins.showLog(30)
    }

    initEvents(){
        super.initEvents()
        this.btnOk.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_btnOk, this);
        this.ticketArea.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_btnOk, this);
    }

    removeEvents(){
        super.removeEvents()
        this.btnOk.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_btnOk, this);
        this.ticketArea.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_btnOk, this);
    }

    onTap_btnOk(){
        NetBuried.ins.clickLog(30)
        window.location.href=DataManager.ins.getPlugOrderStatusData.lottery.link;
    }

}