import Panel from "../views/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";

export default class GetTicketPanel extends Panel {
    public get skinKey() { return "GetTicketPanel" }
    public btnOk: eui.Button;
    public ticketName: eui.Label;
    public ticketArea: eui.Image;

    constructor(data: any) {
        super(data);
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.btnOk.addEventListener(egret.TouchEvent.TOUCH_TAP, this.hidePanel, this);
        this.ticketName.text = DataManager.ins.getPlugOrderStatusData.lottery.title;
        this.ticketArea.source = DataManager.ins.getPlugOrderStatusData.lottery.imgurl;
    }
}