import Panel from "../views/Panel";
import AchievementItem from "../item/AchievementItem";
import LayoutGroup, { LineLayoutGroupType } from "../components/LayoutGroup";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";

export default class AchievementPanel extends Panel {
    public get skinKey() { return "AchievementPanel" }

    public dataGroup: eui.DataGroup;

   

    onSkinComplete() {
        super.onSkinComplete();
        let data=DataManager.ins.getData(NetName.EVOLUTION_RECORD_KUWO).data

        let dataTo=[]
        for(let i=0;i<6;i++){
            if(data[i]){
                dataTo.push({
                    id: 2+i,
                    locked: false,
                    gmtCreate:data[i].gmtCreate
                })
            }else{
                dataTo.push({
                    id: 2+i,
                    locked: true,
                    gmtCreate:null
                })
            }
        }
        (this.dataGroup.dataProvider as eui.ArrayCollection).source = [
            {
                id: 2,
                locked: true
            },
            {
                id: 3,
                locked: true
            },
            {
                id: 4,
                locked: true
            },
            {
                id: 5,
                locked: true
            },
            {
                id: 6,
                locked: true
            },
            {
                id: 7,
                locked: true
            }
        ];

        this.dataGroup.itemRenderer = AchievementItem;
    }

    envent_s

    initEvents(){
        super.initEvents()
        GDispatcher.addEvent("closeAchievement",this.onTouchTap,this)
    }

    removeEvents(){
        super.removeEvents()
        GDispatcher.removeEvent("closeAchievement",this.onTouchTap,this)
    }
}